/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lambda.model.AccountLimit;

@SdkInternalApi
public class AccountLimitMarshaller {
    private static final MarshallingInfo<Long> TOTALCODESIZE_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCodeSize").build();
    private static final MarshallingInfo<Long> CODESIZEUNZIPPED_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSizeUnzipped").build();
    private static final MarshallingInfo<Long> CODESIZEZIPPED_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSizeZipped").build();
    private static final MarshallingInfo<Integer> CONCURRENTEXECUTIONS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConcurrentExecutions").build();
    private static final MarshallingInfo<Integer> UNRESERVEDCONCURRENTEXECUTIONS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnreservedConcurrentExecutions").build();
    private static final AccountLimitMarshaller instance = new AccountLimitMarshaller();

    public static AccountLimitMarshaller getInstance() {
        return instance;
    }

    public void marshall(AccountLimit accountLimit, ProtocolMarshaller protocolMarshaller) {
        if (accountLimit == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(accountLimit.getTotalCodeSize(), TOTALCODESIZE_BINDING);
            protocolMarshaller.marshall(accountLimit.getCodeSizeUnzipped(), CODESIZEUNZIPPED_BINDING);
            protocolMarshaller.marshall(accountLimit.getCodeSizeZipped(), CODESIZEZIPPED_BINDING);
            protocolMarshaller.marshall(accountLimit.getConcurrentExecutions(), CONCURRENTEXECUTIONS_BINDING);
            protocolMarshaller.marshall(accountLimit.getUnreservedConcurrentExecutions(), UNRESERVEDCONCURRENTEXECUTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

