/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.GroupNameAndArn;
import com.amazonaws.services.iot.model.transform.ThingGroupMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ThingGroupMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String parentGroupName;
    private List<GroupNameAndArn> rootToParentThingGroups;
    private Date creationDate;

    public void setParentGroupName(String parentGroupName) {
        this.parentGroupName = parentGroupName;
    }

    public String getParentGroupName() {
        return this.parentGroupName;
    }

    public ThingGroupMetadata withParentGroupName(String parentGroupName) {
        this.setParentGroupName(parentGroupName);
        return this;
    }

    public List<GroupNameAndArn> getRootToParentThingGroups() {
        return this.rootToParentThingGroups;
    }

    public void setRootToParentThingGroups(Collection<GroupNameAndArn> rootToParentThingGroups) {
        if (rootToParentThingGroups == null) {
            this.rootToParentThingGroups = null;
            return;
        }
        this.rootToParentThingGroups = new ArrayList<GroupNameAndArn>(rootToParentThingGroups);
    }

    public ThingGroupMetadata withRootToParentThingGroups(GroupNameAndArn ... rootToParentThingGroups) {
        if (this.rootToParentThingGroups == null) {
            this.setRootToParentThingGroups(new ArrayList<GroupNameAndArn>(rootToParentThingGroups.length));
        }
        for (GroupNameAndArn ele : rootToParentThingGroups) {
            this.rootToParentThingGroups.add(ele);
        }
        return this;
    }

    public ThingGroupMetadata withRootToParentThingGroups(Collection<GroupNameAndArn> rootToParentThingGroups) {
        this.setRootToParentThingGroups(rootToParentThingGroups);
        return this;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public ThingGroupMetadata withCreationDate(Date creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getParentGroupName() != null) {
            sb.append("ParentGroupName: ").append(this.getParentGroupName()).append(",");
        }
        if (this.getRootToParentThingGroups() != null) {
            sb.append("RootToParentThingGroups: ").append(this.getRootToParentThingGroups()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupMetadata)) {
            return false;
        }
        ThingGroupMetadata other = (ThingGroupMetadata)obj;
        if (other.getParentGroupName() == null ^ this.getParentGroupName() == null) {
            return false;
        }
        if (other.getParentGroupName() != null && !other.getParentGroupName().equals(this.getParentGroupName())) {
            return false;
        }
        if (other.getRootToParentThingGroups() == null ^ this.getRootToParentThingGroups() == null) {
            return false;
        }
        if (other.getRootToParentThingGroups() != null && !other.getRootToParentThingGroups().equals(this.getRootToParentThingGroups())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        return other.getCreationDate() == null || other.getCreationDate().equals(this.getCreationDate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getParentGroupName() == null ? 0 : this.getParentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getRootToParentThingGroups() == null ? 0 : this.getRootToParentThingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        return hashCode;
    }

    public ThingGroupMetadata clone() {
        try {
            return (ThingGroupMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingGroupMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

