/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrass.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrass.model.ResourceDataContainer;

@SdkInternalApi
public class ResourceDataContainerMarshaller {
    private static final MarshallingInfo<StructuredPojo> LOCALDEVICERESOURCEDATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalDeviceResourceData").build();
    private static final MarshallingInfo<StructuredPojo> LOCALVOLUMERESOURCEDATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalVolumeResourceData").build();
    private static final ResourceDataContainerMarshaller instance = new ResourceDataContainerMarshaller();

    public static ResourceDataContainerMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceDataContainer resourceDataContainer, ProtocolMarshaller protocolMarshaller) {
        if (resourceDataContainer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourceDataContainer.getLocalDeviceResourceData(), LOCALDEVICERESOURCEDATA_BINDING);
            protocolMarshaller.marshall(resourceDataContainer.getLocalVolumeResourceData(), LOCALVOLUMERESOURCEDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

