/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import com.amazonaws.services.elasticache.model.ReshardingConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyReplicationGroupShardConfigurationRequestMarshaller
implements Marshaller<Request<ModifyReplicationGroupShardConfigurationRequest>, ModifyReplicationGroupShardConfigurationRequest> {
    @Override
    public Request<ModifyReplicationGroupShardConfigurationRequest> marshall(ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest) {
        SdkInternalList nodeGroupsToRemoveList;
        SdkInternalList reshardingConfigurationList;
        if (modifyReplicationGroupShardConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyReplicationGroupShardConfigurationRequest> request = new DefaultRequest<ModifyReplicationGroupShardConfigurationRequest>(modifyReplicationGroupShardConfigurationRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyReplicationGroupShardConfiguration");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReplicationGroupShardConfigurationRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString(modifyReplicationGroupShardConfigurationRequest.getReplicationGroupId()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.getNodeGroupCount() != null) {
            request.addParameter("NodeGroupCount", StringUtils.fromInteger(modifyReplicationGroupShardConfigurationRequest.getNodeGroupCount()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean(modifyReplicationGroupShardConfigurationRequest.getApplyImmediately()));
        }
        if (!(reshardingConfigurationList = (SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getReshardingConfiguration()).isEmpty() || !reshardingConfigurationList.isAutoConstruct()) {
            int reshardingConfigurationListIndex = 1;
            for (ReshardingConfiguration reshardingConfigurationListValue : reshardingConfigurationList) {
                SdkInternalList preferredAvailabilityZonesList = (SdkInternalList)reshardingConfigurationListValue.getPreferredAvailabilityZones();
                if (!preferredAvailabilityZonesList.isEmpty() || !preferredAvailabilityZonesList.isAutoConstruct()) {
                    int preferredAvailabilityZonesListIndex = 1;
                    for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                        if (preferredAvailabilityZonesListValue != null) {
                            request.addParameter("ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".PreferredAvailabilityZones.AvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString(preferredAvailabilityZonesListValue));
                        }
                        ++preferredAvailabilityZonesListIndex;
                    }
                }
                ++reshardingConfigurationListIndex;
            }
        }
        if (!(nodeGroupsToRemoveList = (SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRemove()).isEmpty() || !nodeGroupsToRemoveList.isAutoConstruct()) {
            int nodeGroupsToRemoveListIndex = 1;
            for (String nodeGroupsToRemoveListValue : nodeGroupsToRemoveList) {
                if (nodeGroupsToRemoveListValue != null) {
                    request.addParameter("NodeGroupsToRemove.NodeGroupToRemove." + nodeGroupsToRemoveListIndex, StringUtils.fromString(nodeGroupsToRemoveListValue));
                }
                ++nodeGroupsToRemoveListIndex;
            }
        }
        return request;
    }
}

