/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.PciId;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PciIdStaxUnmarshaller
implements Unmarshaller<PciId, StaxUnmarshallerContext> {
    private static PciIdStaxUnmarshaller instance;

    @Override
    public PciId unmarshall(StaxUnmarshallerContext context) throws Exception {
        PciId pciId = new PciId();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return pciId;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DeviceId", targetDepth)) {
                    pciId.setDeviceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VendorId", targetDepth)) {
                    pciId.setVendorId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubsystemId", targetDepth)) {
                    pciId.setSubsystemId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SubsystemVendorId", targetDepth)) continue;
                pciId.setSubsystemVendorId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return pciId;
    }

    public static PciIdStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PciIdStaxUnmarshaller();
        }
        return instance;
    }
}

