/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CreditSpecificationRequest;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ElasticGpuSpecification;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.InstanceMarketOptionsRequest;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.LaunchTemplateSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.ShutdownBehavior;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.RunInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RunInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<RunInstancesRequest> {
    private SdkInternalList<BlockDeviceMapping> blockDeviceMappings;
    private String imageId;
    private String instanceType;
    private Integer ipv6AddressCount;
    private SdkInternalList<InstanceIpv6Address> ipv6Addresses;
    private String kernelId;
    private String keyName;
    private Integer maxCount;
    private Integer minCount;
    private Boolean monitoring;
    private Placement placement;
    private String ramdiskId;
    private SdkInternalList<String> securityGroupIds;
    private SdkInternalList<String> securityGroups;
    private String subnetId;
    private String userData;
    private String additionalInfo;
    private String clientToken;
    private Boolean disableApiTermination;
    private Boolean ebsOptimized;
    private IamInstanceProfileSpecification iamInstanceProfile;
    private String instanceInitiatedShutdownBehavior;
    private SdkInternalList<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private String privateIpAddress;
    private SdkInternalList<ElasticGpuSpecification> elasticGpuSpecification;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private LaunchTemplateSpecification launchTemplate;
    private InstanceMarketOptionsRequest instanceMarketOptions;
    private CreditSpecificationRequest creditSpecification;

    public RunInstancesRequest() {
    }

    public RunInstancesRequest(String imageId, Integer minCount, Integer maxCount) {
        this.setImageId(imageId);
        this.setMinCount(minCount);
        this.setMaxCount(maxCount);
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings);
    }

    public RunInstancesRequest withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public RunInstancesRequest withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public RunInstancesRequest withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public RunInstancesRequest withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.withInstanceType(instanceType);
    }

    public RunInstancesRequest withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setIpv6AddressCount(Integer ipv6AddressCount) {
        this.ipv6AddressCount = ipv6AddressCount;
    }

    public Integer getIpv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public RunInstancesRequest withIpv6AddressCount(Integer ipv6AddressCount) {
        this.setIpv6AddressCount(ipv6AddressCount);
        return this;
    }

    public List<InstanceIpv6Address> getIpv6Addresses() {
        if (this.ipv6Addresses == null) {
            this.ipv6Addresses = new SdkInternalList();
        }
        return this.ipv6Addresses;
    }

    public void setIpv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
        if (ipv6Addresses == null) {
            this.ipv6Addresses = null;
            return;
        }
        this.ipv6Addresses = new SdkInternalList<InstanceIpv6Address>(ipv6Addresses);
    }

    public RunInstancesRequest withIpv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
        if (this.ipv6Addresses == null) {
            this.setIpv6Addresses(new SdkInternalList<InstanceIpv6Address>(ipv6Addresses.length));
        }
        for (InstanceIpv6Address ele : ipv6Addresses) {
            this.ipv6Addresses.add(ele);
        }
        return this;
    }

    public RunInstancesRequest withIpv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
        this.setIpv6Addresses(ipv6Addresses);
        return this;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public RunInstancesRequest withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public RunInstancesRequest withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public RunInstancesRequest withMaxCount(Integer maxCount) {
        this.setMaxCount(maxCount);
        return this;
    }

    public void setMinCount(Integer minCount) {
        this.minCount = minCount;
    }

    public Integer getMinCount() {
        return this.minCount;
    }

    public RunInstancesRequest withMinCount(Integer minCount) {
        this.setMinCount(minCount);
        return this;
    }

    public void setMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
    }

    public Boolean getMonitoring() {
        return this.monitoring;
    }

    public RunInstancesRequest withMonitoring(Boolean monitoring) {
        this.setMonitoring(monitoring);
        return this;
    }

    public Boolean isMonitoring() {
        return this.monitoring;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public RunInstancesRequest withPlacement(Placement placement) {
        this.setPlacement(placement);
        return this;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public RunInstancesRequest withRamdiskId(String ramdiskId) {
        this.setRamdiskId(ramdiskId);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new SdkInternalList();
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new SdkInternalList<String>(securityGroupIds);
    }

    public RunInstancesRequest withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new SdkInternalList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public RunInstancesRequest withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList<String>(securityGroups);
    }

    public RunInstancesRequest withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new SdkInternalList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public RunInstancesRequest withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public RunInstancesRequest withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    public RunInstancesRequest withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public RunInstancesRequest withAdditionalInfo(String additionalInfo) {
        this.setAdditionalInfo(additionalInfo);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public RunInstancesRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDisableApiTermination(Boolean disableApiTermination) {
        this.disableApiTermination = disableApiTermination;
    }

    public Boolean getDisableApiTermination() {
        return this.disableApiTermination;
    }

    public RunInstancesRequest withDisableApiTermination(Boolean disableApiTermination) {
        this.setDisableApiTermination(disableApiTermination);
        return this;
    }

    public Boolean isDisableApiTermination() {
        return this.disableApiTermination;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public RunInstancesRequest withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public IamInstanceProfileSpecification getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public RunInstancesRequest withIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
        this.setIamInstanceProfile(iamInstanceProfile);
        return this;
    }

    public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
    }

    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public RunInstancesRequest withInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.setInstanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
        return this;
    }

    public void setInstanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
        this.withInstanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
    }

    public RunInstancesRequest withInstanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior.toString();
        return this;
    }

    public List<InstanceNetworkInterfaceSpecification> getNetworkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new SdkInternalList();
        }
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new SdkInternalList<InstanceNetworkInterfaceSpecification>(networkInterfaces);
    }

    public RunInstancesRequest withNetworkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces(new SdkInternalList<InstanceNetworkInterfaceSpecification>(networkInterfaces.length));
        }
        for (InstanceNetworkInterfaceSpecification ele : networkInterfaces) {
            this.networkInterfaces.add(ele);
        }
        return this;
    }

    public RunInstancesRequest withNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public RunInstancesRequest withPrivateIpAddress(String privateIpAddress) {
        this.setPrivateIpAddress(privateIpAddress);
        return this;
    }

    public List<ElasticGpuSpecification> getElasticGpuSpecification() {
        if (this.elasticGpuSpecification == null) {
            this.elasticGpuSpecification = new SdkInternalList();
        }
        return this.elasticGpuSpecification;
    }

    public void setElasticGpuSpecification(Collection<ElasticGpuSpecification> elasticGpuSpecification) {
        if (elasticGpuSpecification == null) {
            this.elasticGpuSpecification = null;
            return;
        }
        this.elasticGpuSpecification = new SdkInternalList<ElasticGpuSpecification>(elasticGpuSpecification);
    }

    public RunInstancesRequest withElasticGpuSpecification(ElasticGpuSpecification ... elasticGpuSpecification) {
        if (this.elasticGpuSpecification == null) {
            this.setElasticGpuSpecification(new SdkInternalList<ElasticGpuSpecification>(elasticGpuSpecification.length));
        }
        for (ElasticGpuSpecification ele : elasticGpuSpecification) {
            this.elasticGpuSpecification.add(ele);
        }
        return this;
    }

    public RunInstancesRequest withElasticGpuSpecification(Collection<ElasticGpuSpecification> elasticGpuSpecification) {
        this.setElasticGpuSpecification(elasticGpuSpecification);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public RunInstancesRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public RunInstancesRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setLaunchTemplate(LaunchTemplateSpecification launchTemplate) {
        this.launchTemplate = launchTemplate;
    }

    public LaunchTemplateSpecification getLaunchTemplate() {
        return this.launchTemplate;
    }

    public RunInstancesRequest withLaunchTemplate(LaunchTemplateSpecification launchTemplate) {
        this.setLaunchTemplate(launchTemplate);
        return this;
    }

    public void setInstanceMarketOptions(InstanceMarketOptionsRequest instanceMarketOptions) {
        this.instanceMarketOptions = instanceMarketOptions;
    }

    public InstanceMarketOptionsRequest getInstanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public RunInstancesRequest withInstanceMarketOptions(InstanceMarketOptionsRequest instanceMarketOptions) {
        this.setInstanceMarketOptions(instanceMarketOptions);
        return this;
    }

    public void setCreditSpecification(CreditSpecificationRequest creditSpecification) {
        this.creditSpecification = creditSpecification;
    }

    public CreditSpecificationRequest getCreditSpecification() {
        return this.creditSpecification;
    }

    public RunInstancesRequest withCreditSpecification(CreditSpecificationRequest creditSpecification) {
        this.setCreditSpecification(creditSpecification);
        return this;
    }

    @Override
    public Request<RunInstancesRequest> getDryRunRequest() {
        Request<RunInstancesRequest> request = new RunInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getIpv6AddressCount() != null) {
            sb.append("Ipv6AddressCount: ").append(this.getIpv6AddressCount()).append(",");
        }
        if (this.getIpv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.getIpv6Addresses()).append(",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getMaxCount() != null) {
            sb.append("MaxCount: ").append(this.getMaxCount()).append(",");
        }
        if (this.getMinCount() != null) {
            sb.append("MinCount: ").append(this.getMinCount()).append(",");
        }
        if (this.getMonitoring() != null) {
            sb.append("Monitoring: ").append(this.getMonitoring()).append(",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: ").append(this.getPlacement()).append(",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: ").append(this.getRamdiskId()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: ").append(this.getUserData()).append(",");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.getAdditionalInfo()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDisableApiTermination() != null) {
            sb.append("DisableApiTermination: ").append(this.getDisableApiTermination()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getIamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.getIamInstanceProfile()).append(",");
        }
        if (this.getInstanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(this.getInstanceInitiatedShutdownBehavior()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces()).append(",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.getPrivateIpAddress()).append(",");
        }
        if (this.getElasticGpuSpecification() != null) {
            sb.append("ElasticGpuSpecification: ").append(this.getElasticGpuSpecification()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getLaunchTemplate() != null) {
            sb.append("LaunchTemplate: ").append(this.getLaunchTemplate()).append(",");
        }
        if (this.getInstanceMarketOptions() != null) {
            sb.append("InstanceMarketOptions: ").append(this.getInstanceMarketOptions()).append(",");
        }
        if (this.getCreditSpecification() != null) {
            sb.append("CreditSpecification: ").append(this.getCreditSpecification());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunInstancesRequest)) {
            return false;
        }
        RunInstancesRequest other = (RunInstancesRequest)obj;
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getIpv6AddressCount() == null ^ this.getIpv6AddressCount() == null) {
            return false;
        }
        if (other.getIpv6AddressCount() != null && !other.getIpv6AddressCount().equals(this.getIpv6AddressCount())) {
            return false;
        }
        if (other.getIpv6Addresses() == null ^ this.getIpv6Addresses() == null) {
            return false;
        }
        if (other.getIpv6Addresses() != null && !other.getIpv6Addresses().equals(this.getIpv6Addresses())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getMaxCount() == null ^ this.getMaxCount() == null) {
            return false;
        }
        if (other.getMaxCount() != null && !other.getMaxCount().equals(this.getMaxCount())) {
            return false;
        }
        if (other.getMinCount() == null ^ this.getMinCount() == null) {
            return false;
        }
        if (other.getMinCount() != null && !other.getMinCount().equals(this.getMinCount())) {
            return false;
        }
        if (other.getMonitoring() == null ^ this.getMonitoring() == null) {
            return false;
        }
        if (other.getMonitoring() != null && !other.getMonitoring().equals(this.getMonitoring())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        if (other.getAdditionalInfo() != null && !other.getAdditionalInfo().equals(this.getAdditionalInfo())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDisableApiTermination() == null ^ this.getDisableApiTermination() == null) {
            return false;
        }
        if (other.getDisableApiTermination() != null && !other.getDisableApiTermination().equals(this.getDisableApiTermination())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() == null ^ this.getInstanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() != null && !other.getInstanceInitiatedShutdownBehavior().equals(this.getInstanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getElasticGpuSpecification() == null ^ this.getElasticGpuSpecification() == null) {
            return false;
        }
        if (other.getElasticGpuSpecification() != null && !other.getElasticGpuSpecification().equals(this.getElasticGpuSpecification())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getLaunchTemplate() == null ^ this.getLaunchTemplate() == null) {
            return false;
        }
        if (other.getLaunchTemplate() != null && !other.getLaunchTemplate().equals(this.getLaunchTemplate())) {
            return false;
        }
        if (other.getInstanceMarketOptions() == null ^ this.getInstanceMarketOptions() == null) {
            return false;
        }
        if (other.getInstanceMarketOptions() != null && !other.getInstanceMarketOptions().equals(this.getInstanceMarketOptions())) {
            return false;
        }
        if (other.getCreditSpecification() == null ^ this.getCreditSpecification() == null) {
            return false;
        }
        return other.getCreditSpecification() == null || other.getCreditSpecification().equals(this.getCreditSpecification());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6AddressCount() == null ? 0 : this.getIpv6AddressCount().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6Addresses() == null ? 0 : this.getIpv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCount() == null ? 0 : this.getMaxCount().hashCode());
        hashCode = 31 * hashCode + (this.getMinCount() == null ? 0 : this.getMinCount().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoring() == null ? 0 : this.getMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDisableApiTermination() == null ? 0 : this.getDisableApiTermination().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceInitiatedShutdownBehavior() == null ? 0 : this.getInstanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getElasticGpuSpecification() == null ? 0 : this.getElasticGpuSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTemplate() == null ? 0 : this.getLaunchTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceMarketOptions() == null ? 0 : this.getInstanceMarketOptions().hashCode());
        hashCode = 31 * hashCode + (this.getCreditSpecification() == null ? 0 : this.getCreditSpecification().hashCode());
        return hashCode;
    }

    @Override
    public RunInstancesRequest clone() {
        return (RunInstancesRequest)super.clone();
    }
}

