/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.appsync.AWSAppSyncAsync;
import com.amazonaws.services.appsync.AWSAppSyncAsyncClientBuilder;
import com.amazonaws.services.appsync.AWSAppSyncClient;
import com.amazonaws.services.appsync.model.CreateApiKeyRequest;
import com.amazonaws.services.appsync.model.CreateApiKeyResult;
import com.amazonaws.services.appsync.model.CreateDataSourceRequest;
import com.amazonaws.services.appsync.model.CreateDataSourceResult;
import com.amazonaws.services.appsync.model.CreateGraphqlApiRequest;
import com.amazonaws.services.appsync.model.CreateGraphqlApiResult;
import com.amazonaws.services.appsync.model.CreateResolverRequest;
import com.amazonaws.services.appsync.model.CreateResolverResult;
import com.amazonaws.services.appsync.model.CreateTypeRequest;
import com.amazonaws.services.appsync.model.CreateTypeResult;
import com.amazonaws.services.appsync.model.DeleteApiKeyRequest;
import com.amazonaws.services.appsync.model.DeleteApiKeyResult;
import com.amazonaws.services.appsync.model.DeleteDataSourceRequest;
import com.amazonaws.services.appsync.model.DeleteDataSourceResult;
import com.amazonaws.services.appsync.model.DeleteGraphqlApiRequest;
import com.amazonaws.services.appsync.model.DeleteGraphqlApiResult;
import com.amazonaws.services.appsync.model.DeleteResolverRequest;
import com.amazonaws.services.appsync.model.DeleteResolverResult;
import com.amazonaws.services.appsync.model.DeleteTypeRequest;
import com.amazonaws.services.appsync.model.DeleteTypeResult;
import com.amazonaws.services.appsync.model.GetDataSourceRequest;
import com.amazonaws.services.appsync.model.GetDataSourceResult;
import com.amazonaws.services.appsync.model.GetGraphqlApiRequest;
import com.amazonaws.services.appsync.model.GetGraphqlApiResult;
import com.amazonaws.services.appsync.model.GetIntrospectionSchemaRequest;
import com.amazonaws.services.appsync.model.GetIntrospectionSchemaResult;
import com.amazonaws.services.appsync.model.GetResolverRequest;
import com.amazonaws.services.appsync.model.GetResolverResult;
import com.amazonaws.services.appsync.model.GetSchemaCreationStatusRequest;
import com.amazonaws.services.appsync.model.GetSchemaCreationStatusResult;
import com.amazonaws.services.appsync.model.GetTypeRequest;
import com.amazonaws.services.appsync.model.GetTypeResult;
import com.amazonaws.services.appsync.model.ListApiKeysRequest;
import com.amazonaws.services.appsync.model.ListApiKeysResult;
import com.amazonaws.services.appsync.model.ListDataSourcesRequest;
import com.amazonaws.services.appsync.model.ListDataSourcesResult;
import com.amazonaws.services.appsync.model.ListGraphqlApisRequest;
import com.amazonaws.services.appsync.model.ListGraphqlApisResult;
import com.amazonaws.services.appsync.model.ListResolversRequest;
import com.amazonaws.services.appsync.model.ListResolversResult;
import com.amazonaws.services.appsync.model.ListTypesRequest;
import com.amazonaws.services.appsync.model.ListTypesResult;
import com.amazonaws.services.appsync.model.StartSchemaCreationRequest;
import com.amazonaws.services.appsync.model.StartSchemaCreationResult;
import com.amazonaws.services.appsync.model.UpdateApiKeyRequest;
import com.amazonaws.services.appsync.model.UpdateApiKeyResult;
import com.amazonaws.services.appsync.model.UpdateDataSourceRequest;
import com.amazonaws.services.appsync.model.UpdateDataSourceResult;
import com.amazonaws.services.appsync.model.UpdateGraphqlApiRequest;
import com.amazonaws.services.appsync.model.UpdateGraphqlApiResult;
import com.amazonaws.services.appsync.model.UpdateResolverRequest;
import com.amazonaws.services.appsync.model.UpdateResolverResult;
import com.amazonaws.services.appsync.model.UpdateTypeRequest;
import com.amazonaws.services.appsync.model.UpdateTypeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSAppSyncAsyncClient
extends AWSAppSyncClient
implements AWSAppSyncAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSAppSyncAsyncClientBuilder asyncBuilder() {
        return AWSAppSyncAsyncClientBuilder.standard();
    }

    AWSAppSyncAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateApiKeyResult> createApiKeyAsync(CreateApiKeyRequest request) {
        return this.createApiKeyAsync(request, null);
    }

    @Override
    public Future<CreateApiKeyResult> createApiKeyAsync(CreateApiKeyRequest request, final AsyncHandler<CreateApiKeyRequest, CreateApiKeyResult> asyncHandler) {
        final CreateApiKeyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateApiKeyResult>(){

            @Override
            public CreateApiKeyResult call() throws Exception {
                CreateApiKeyResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeCreateApiKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceResult> createDataSourceAsync(CreateDataSourceRequest request) {
        return this.createDataSourceAsync(request, null);
    }

    @Override
    public Future<CreateDataSourceResult> createDataSourceAsync(CreateDataSourceRequest request, final AsyncHandler<CreateDataSourceRequest, CreateDataSourceResult> asyncHandler) {
        final CreateDataSourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataSourceResult>(){

            @Override
            public CreateDataSourceResult call() throws Exception {
                CreateDataSourceResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeCreateDataSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGraphqlApiResult> createGraphqlApiAsync(CreateGraphqlApiRequest request) {
        return this.createGraphqlApiAsync(request, null);
    }

    @Override
    public Future<CreateGraphqlApiResult> createGraphqlApiAsync(CreateGraphqlApiRequest request, final AsyncHandler<CreateGraphqlApiRequest, CreateGraphqlApiResult> asyncHandler) {
        final CreateGraphqlApiRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGraphqlApiResult>(){

            @Override
            public CreateGraphqlApiResult call() throws Exception {
                CreateGraphqlApiResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeCreateGraphqlApi(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateResolverResult> createResolverAsync(CreateResolverRequest request) {
        return this.createResolverAsync(request, null);
    }

    @Override
    public Future<CreateResolverResult> createResolverAsync(CreateResolverRequest request, final AsyncHandler<CreateResolverRequest, CreateResolverResult> asyncHandler) {
        final CreateResolverRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateResolverResult>(){

            @Override
            public CreateResolverResult call() throws Exception {
                CreateResolverResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeCreateResolver(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTypeResult> createTypeAsync(CreateTypeRequest request) {
        return this.createTypeAsync(request, null);
    }

    @Override
    public Future<CreateTypeResult> createTypeAsync(CreateTypeRequest request, final AsyncHandler<CreateTypeRequest, CreateTypeResult> asyncHandler) {
        final CreateTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTypeResult>(){

            @Override
            public CreateTypeResult call() throws Exception {
                CreateTypeResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeCreateType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApiKeyResult> deleteApiKeyAsync(DeleteApiKeyRequest request) {
        return this.deleteApiKeyAsync(request, null);
    }

    @Override
    public Future<DeleteApiKeyResult> deleteApiKeyAsync(DeleteApiKeyRequest request, final AsyncHandler<DeleteApiKeyRequest, DeleteApiKeyResult> asyncHandler) {
        final DeleteApiKeyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteApiKeyResult>(){

            @Override
            public DeleteApiKeyResult call() throws Exception {
                DeleteApiKeyResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeDeleteApiKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataSourceResult> deleteDataSourceAsync(DeleteDataSourceRequest request) {
        return this.deleteDataSourceAsync(request, null);
    }

    @Override
    public Future<DeleteDataSourceResult> deleteDataSourceAsync(DeleteDataSourceRequest request, final AsyncHandler<DeleteDataSourceRequest, DeleteDataSourceResult> asyncHandler) {
        final DeleteDataSourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDataSourceResult>(){

            @Override
            public DeleteDataSourceResult call() throws Exception {
                DeleteDataSourceResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeDeleteDataSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGraphqlApiResult> deleteGraphqlApiAsync(DeleteGraphqlApiRequest request) {
        return this.deleteGraphqlApiAsync(request, null);
    }

    @Override
    public Future<DeleteGraphqlApiResult> deleteGraphqlApiAsync(DeleteGraphqlApiRequest request, final AsyncHandler<DeleteGraphqlApiRequest, DeleteGraphqlApiResult> asyncHandler) {
        final DeleteGraphqlApiRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGraphqlApiResult>(){

            @Override
            public DeleteGraphqlApiResult call() throws Exception {
                DeleteGraphqlApiResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeDeleteGraphqlApi(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteResolverResult> deleteResolverAsync(DeleteResolverRequest request) {
        return this.deleteResolverAsync(request, null);
    }

    @Override
    public Future<DeleteResolverResult> deleteResolverAsync(DeleteResolverRequest request, final AsyncHandler<DeleteResolverRequest, DeleteResolverResult> asyncHandler) {
        final DeleteResolverRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteResolverResult>(){

            @Override
            public DeleteResolverResult call() throws Exception {
                DeleteResolverResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeDeleteResolver(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTypeResult> deleteTypeAsync(DeleteTypeRequest request) {
        return this.deleteTypeAsync(request, null);
    }

    @Override
    public Future<DeleteTypeResult> deleteTypeAsync(DeleteTypeRequest request, final AsyncHandler<DeleteTypeRequest, DeleteTypeResult> asyncHandler) {
        final DeleteTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTypeResult>(){

            @Override
            public DeleteTypeResult call() throws Exception {
                DeleteTypeResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeDeleteType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataSourceResult> getDataSourceAsync(GetDataSourceRequest request) {
        return this.getDataSourceAsync(request, null);
    }

    @Override
    public Future<GetDataSourceResult> getDataSourceAsync(GetDataSourceRequest request, final AsyncHandler<GetDataSourceRequest, GetDataSourceResult> asyncHandler) {
        final GetDataSourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataSourceResult>(){

            @Override
            public GetDataSourceResult call() throws Exception {
                GetDataSourceResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeGetDataSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGraphqlApiResult> getGraphqlApiAsync(GetGraphqlApiRequest request) {
        return this.getGraphqlApiAsync(request, null);
    }

    @Override
    public Future<GetGraphqlApiResult> getGraphqlApiAsync(GetGraphqlApiRequest request, final AsyncHandler<GetGraphqlApiRequest, GetGraphqlApiResult> asyncHandler) {
        final GetGraphqlApiRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGraphqlApiResult>(){

            @Override
            public GetGraphqlApiResult call() throws Exception {
                GetGraphqlApiResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeGetGraphqlApi(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIntrospectionSchemaResult> getIntrospectionSchemaAsync(GetIntrospectionSchemaRequest request) {
        return this.getIntrospectionSchemaAsync(request, null);
    }

    @Override
    public Future<GetIntrospectionSchemaResult> getIntrospectionSchemaAsync(GetIntrospectionSchemaRequest request, final AsyncHandler<GetIntrospectionSchemaRequest, GetIntrospectionSchemaResult> asyncHandler) {
        final GetIntrospectionSchemaRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetIntrospectionSchemaResult>(){

            @Override
            public GetIntrospectionSchemaResult call() throws Exception {
                GetIntrospectionSchemaResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeGetIntrospectionSchema(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResolverResult> getResolverAsync(GetResolverRequest request) {
        return this.getResolverAsync(request, null);
    }

    @Override
    public Future<GetResolverResult> getResolverAsync(GetResolverRequest request, final AsyncHandler<GetResolverRequest, GetResolverResult> asyncHandler) {
        final GetResolverRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResolverResult>(){

            @Override
            public GetResolverResult call() throws Exception {
                GetResolverResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeGetResolver(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSchemaCreationStatusResult> getSchemaCreationStatusAsync(GetSchemaCreationStatusRequest request) {
        return this.getSchemaCreationStatusAsync(request, null);
    }

    @Override
    public Future<GetSchemaCreationStatusResult> getSchemaCreationStatusAsync(GetSchemaCreationStatusRequest request, final AsyncHandler<GetSchemaCreationStatusRequest, GetSchemaCreationStatusResult> asyncHandler) {
        final GetSchemaCreationStatusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSchemaCreationStatusResult>(){

            @Override
            public GetSchemaCreationStatusResult call() throws Exception {
                GetSchemaCreationStatusResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeGetSchemaCreationStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTypeResult> getTypeAsync(GetTypeRequest request) {
        return this.getTypeAsync(request, null);
    }

    @Override
    public Future<GetTypeResult> getTypeAsync(GetTypeRequest request, final AsyncHandler<GetTypeRequest, GetTypeResult> asyncHandler) {
        final GetTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTypeResult>(){

            @Override
            public GetTypeResult call() throws Exception {
                GetTypeResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeGetType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApiKeysResult> listApiKeysAsync(ListApiKeysRequest request) {
        return this.listApiKeysAsync(request, null);
    }

    @Override
    public Future<ListApiKeysResult> listApiKeysAsync(ListApiKeysRequest request, final AsyncHandler<ListApiKeysRequest, ListApiKeysResult> asyncHandler) {
        final ListApiKeysRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApiKeysResult>(){

            @Override
            public ListApiKeysResult call() throws Exception {
                ListApiKeysResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeListApiKeys(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataSourcesResult> listDataSourcesAsync(ListDataSourcesRequest request) {
        return this.listDataSourcesAsync(request, null);
    }

    @Override
    public Future<ListDataSourcesResult> listDataSourcesAsync(ListDataSourcesRequest request, final AsyncHandler<ListDataSourcesRequest, ListDataSourcesResult> asyncHandler) {
        final ListDataSourcesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataSourcesResult>(){

            @Override
            public ListDataSourcesResult call() throws Exception {
                ListDataSourcesResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeListDataSources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGraphqlApisResult> listGraphqlApisAsync(ListGraphqlApisRequest request) {
        return this.listGraphqlApisAsync(request, null);
    }

    @Override
    public Future<ListGraphqlApisResult> listGraphqlApisAsync(ListGraphqlApisRequest request, final AsyncHandler<ListGraphqlApisRequest, ListGraphqlApisResult> asyncHandler) {
        final ListGraphqlApisRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGraphqlApisResult>(){

            @Override
            public ListGraphqlApisResult call() throws Exception {
                ListGraphqlApisResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeListGraphqlApis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResolversResult> listResolversAsync(ListResolversRequest request) {
        return this.listResolversAsync(request, null);
    }

    @Override
    public Future<ListResolversResult> listResolversAsync(ListResolversRequest request, final AsyncHandler<ListResolversRequest, ListResolversResult> asyncHandler) {
        final ListResolversRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResolversResult>(){

            @Override
            public ListResolversResult call() throws Exception {
                ListResolversResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeListResolvers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTypesResult> listTypesAsync(ListTypesRequest request) {
        return this.listTypesAsync(request, null);
    }

    @Override
    public Future<ListTypesResult> listTypesAsync(ListTypesRequest request, final AsyncHandler<ListTypesRequest, ListTypesResult> asyncHandler) {
        final ListTypesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTypesResult>(){

            @Override
            public ListTypesResult call() throws Exception {
                ListTypesResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeListTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSchemaCreationResult> startSchemaCreationAsync(StartSchemaCreationRequest request) {
        return this.startSchemaCreationAsync(request, null);
    }

    @Override
    public Future<StartSchemaCreationResult> startSchemaCreationAsync(StartSchemaCreationRequest request, final AsyncHandler<StartSchemaCreationRequest, StartSchemaCreationResult> asyncHandler) {
        final StartSchemaCreationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSchemaCreationResult>(){

            @Override
            public StartSchemaCreationResult call() throws Exception {
                StartSchemaCreationResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeStartSchemaCreation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApiKeyResult> updateApiKeyAsync(UpdateApiKeyRequest request) {
        return this.updateApiKeyAsync(request, null);
    }

    @Override
    public Future<UpdateApiKeyResult> updateApiKeyAsync(UpdateApiKeyRequest request, final AsyncHandler<UpdateApiKeyRequest, UpdateApiKeyResult> asyncHandler) {
        final UpdateApiKeyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateApiKeyResult>(){

            @Override
            public UpdateApiKeyResult call() throws Exception {
                UpdateApiKeyResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeUpdateApiKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataSourceResult> updateDataSourceAsync(UpdateDataSourceRequest request) {
        return this.updateDataSourceAsync(request, null);
    }

    @Override
    public Future<UpdateDataSourceResult> updateDataSourceAsync(UpdateDataSourceRequest request, final AsyncHandler<UpdateDataSourceRequest, UpdateDataSourceResult> asyncHandler) {
        final UpdateDataSourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDataSourceResult>(){

            @Override
            public UpdateDataSourceResult call() throws Exception {
                UpdateDataSourceResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeUpdateDataSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGraphqlApiResult> updateGraphqlApiAsync(UpdateGraphqlApiRequest request) {
        return this.updateGraphqlApiAsync(request, null);
    }

    @Override
    public Future<UpdateGraphqlApiResult> updateGraphqlApiAsync(UpdateGraphqlApiRequest request, final AsyncHandler<UpdateGraphqlApiRequest, UpdateGraphqlApiResult> asyncHandler) {
        final UpdateGraphqlApiRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGraphqlApiResult>(){

            @Override
            public UpdateGraphqlApiResult call() throws Exception {
                UpdateGraphqlApiResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeUpdateGraphqlApi(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateResolverResult> updateResolverAsync(UpdateResolverRequest request) {
        return this.updateResolverAsync(request, null);
    }

    @Override
    public Future<UpdateResolverResult> updateResolverAsync(UpdateResolverRequest request, final AsyncHandler<UpdateResolverRequest, UpdateResolverResult> asyncHandler) {
        final UpdateResolverRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateResolverResult>(){

            @Override
            public UpdateResolverResult call() throws Exception {
                UpdateResolverResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeUpdateResolver(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTypeResult> updateTypeAsync(UpdateTypeRequest request) {
        return this.updateTypeAsync(request, null);
    }

    @Override
    public Future<UpdateTypeResult> updateTypeAsync(UpdateTypeRequest request, final AsyncHandler<UpdateTypeRequest, UpdateTypeResult> asyncHandler) {
        final UpdateTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTypeResult>(){

            @Override
            public UpdateTypeResult call() throws Exception {
                UpdateTypeResult result = null;
                try {
                    result = AWSAppSyncAsyncClient.this.executeUpdateType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

