/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteItemResult
implements Serializable,
Cloneable {
    private Map<String, List<WriteRequest>> unprocessedItems;
    private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;
    private List<ConsumedCapacity> consumedCapacity;

    public Map<String, List<WriteRequest>> getUnprocessedItems() {
        return this.unprocessedItems;
    }

    public void setUnprocessedItems(Map<String, List<WriteRequest>> unprocessedItems) {
        this.unprocessedItems = unprocessedItems;
    }

    public BatchWriteItemResult withUnprocessedItems(Map<String, List<WriteRequest>> unprocessedItems) {
        this.setUnprocessedItems(unprocessedItems);
        return this;
    }

    public BatchWriteItemResult addUnprocessedItemsEntry(String key, List<WriteRequest> value) {
        if (null == this.unprocessedItems) {
            this.unprocessedItems = new HashMap<String, List<WriteRequest>>();
        }
        if (this.unprocessedItems.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.unprocessedItems.put(key, value);
        return this;
    }

    public BatchWriteItemResult clearUnprocessedItemsEntries() {
        this.unprocessedItems = null;
        return this;
    }

    public Map<String, List<ItemCollectionMetrics>> getItemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public void setItemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics) {
        this.itemCollectionMetrics = itemCollectionMetrics;
    }

    public BatchWriteItemResult withItemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics) {
        this.setItemCollectionMetrics(itemCollectionMetrics);
        return this;
    }

    public BatchWriteItemResult addItemCollectionMetricsEntry(String key, List<ItemCollectionMetrics> value) {
        if (null == this.itemCollectionMetrics) {
            this.itemCollectionMetrics = new HashMap<String, List<ItemCollectionMetrics>>();
        }
        if (this.itemCollectionMetrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.itemCollectionMetrics.put(key, value);
        return this;
    }

    public BatchWriteItemResult clearItemCollectionMetricsEntries() {
        this.itemCollectionMetrics = null;
        return this;
    }

    public List<ConsumedCapacity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        if (consumedCapacity == null) {
            this.consumedCapacity = null;
            return;
        }
        this.consumedCapacity = new ArrayList<ConsumedCapacity>(consumedCapacity);
    }

    public BatchWriteItemResult withConsumedCapacity(ConsumedCapacity ... consumedCapacity) {
        if (this.consumedCapacity == null) {
            this.setConsumedCapacity(new ArrayList<ConsumedCapacity>(consumedCapacity.length));
        }
        for (ConsumedCapacity ele : consumedCapacity) {
            this.consumedCapacity.add(ele);
        }
        return this;
    }

    public BatchWriteItemResult withConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        this.setConsumedCapacity(consumedCapacity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUnprocessedItems() != null) {
            sb.append("UnprocessedItems: " + this.getUnprocessedItems() + ",");
        }
        if (this.getItemCollectionMetrics() != null) {
            sb.append("ItemCollectionMetrics: " + this.getItemCollectionMetrics() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            sb.append("ConsumedCapacity: " + this.getConsumedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemResult)) {
            return false;
        }
        BatchWriteItemResult other = (BatchWriteItemResult)obj;
        if (other.getUnprocessedItems() == null ^ this.getUnprocessedItems() == null) {
            return false;
        }
        if (other.getUnprocessedItems() != null && !other.getUnprocessedItems().equals(this.getUnprocessedItems())) {
            return false;
        }
        if (other.getItemCollectionMetrics() == null ^ this.getItemCollectionMetrics() == null) {
            return false;
        }
        if (other.getItemCollectionMetrics() != null && !other.getItemCollectionMetrics().equals(this.getItemCollectionMetrics())) {
            return false;
        }
        if (other.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return other.getConsumedCapacity() == null || other.getConsumedCapacity().equals(this.getConsumedCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUnprocessedItems() == null ? 0 : this.getUnprocessedItems().hashCode());
        hashCode = 31 * hashCode + (this.getItemCollectionMetrics() == null ? 0 : this.getItemCollectionMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        return hashCode;
    }

    public BatchWriteItemResult clone() {
        try {
            return (BatchWriteItemResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

