/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetApiKeysRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetApiKeysRequestMarshaller
implements Marshaller<Request<GetApiKeysRequest>, GetApiKeysRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetApiKeysRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetApiKeysRequest> marshall(GetApiKeysRequest getApiKeysRequest) {
        if (getApiKeysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetApiKeysRequest> request = new DefaultRequest<GetApiKeysRequest>(getApiKeysRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/apikeys";
        request.setResourcePath(uriResourcePath);
        if (getApiKeysRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getApiKeysRequest.getPosition()));
        }
        if (getApiKeysRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getApiKeysRequest.getLimit()));
        }
        if (getApiKeysRequest.getNameQuery() != null) {
            request.addParameter("name", StringUtils.fromString(getApiKeysRequest.getNameQuery()));
        }
        if (getApiKeysRequest.getIncludeValues() != null) {
            request.addParameter("includeValues", StringUtils.fromBoolean(getApiKeysRequest.getIncludeValues()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

