/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mq.model.ConfigurationId;
import com.amazonaws.services.mq.model.transform.ConfigurationsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Configurations
implements Serializable,
Cloneable,
StructuredPojo {
    private ConfigurationId current;
    private List<ConfigurationId> history;
    private ConfigurationId pending;

    public void setCurrent(ConfigurationId current) {
        this.current = current;
    }

    public ConfigurationId getCurrent() {
        return this.current;
    }

    public Configurations withCurrent(ConfigurationId current) {
        this.setCurrent(current);
        return this;
    }

    public List<ConfigurationId> getHistory() {
        return this.history;
    }

    public void setHistory(Collection<ConfigurationId> history) {
        if (history == null) {
            this.history = null;
            return;
        }
        this.history = new ArrayList<ConfigurationId>(history);
    }

    public Configurations withHistory(ConfigurationId ... history) {
        if (this.history == null) {
            this.setHistory(new ArrayList<ConfigurationId>(history.length));
        }
        for (ConfigurationId ele : history) {
            this.history.add(ele);
        }
        return this;
    }

    public Configurations withHistory(Collection<ConfigurationId> history) {
        this.setHistory(history);
        return this;
    }

    public void setPending(ConfigurationId pending) {
        this.pending = pending;
    }

    public ConfigurationId getPending() {
        return this.pending;
    }

    public Configurations withPending(ConfigurationId pending) {
        this.setPending(pending);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCurrent() != null) {
            sb.append("Current: ").append(this.getCurrent()).append(",");
        }
        if (this.getHistory() != null) {
            sb.append("History: ").append(this.getHistory()).append(",");
        }
        if (this.getPending() != null) {
            sb.append("Pending: ").append(this.getPending());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configurations)) {
            return false;
        }
        Configurations other = (Configurations)obj;
        if (other.getCurrent() == null ^ this.getCurrent() == null) {
            return false;
        }
        if (other.getCurrent() != null && !other.getCurrent().equals(this.getCurrent())) {
            return false;
        }
        if (other.getHistory() == null ^ this.getHistory() == null) {
            return false;
        }
        if (other.getHistory() != null && !other.getHistory().equals(this.getHistory())) {
            return false;
        }
        if (other.getPending() == null ^ this.getPending() == null) {
            return false;
        }
        return other.getPending() == null || other.getPending().equals(this.getPending());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCurrent() == null ? 0 : this.getCurrent().hashCode());
        hashCode = 31 * hashCode + (this.getHistory() == null ? 0 : this.getHistory().hashCode());
        hashCode = 31 * hashCode + (this.getPending() == null ? 0 : this.getPending().hashCode());
        return hashCode;
    }

    public Configurations clone() {
        try {
            return (Configurations)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

