/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.OutputSettings;

@SdkInternalApi
public class OutputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> ARCHIVEOUTPUTSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("archiveOutputSettings").build();
    private static final MarshallingInfo<StructuredPojo> HLSOUTPUTSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsOutputSettings").build();
    private static final MarshallingInfo<StructuredPojo> MSSMOOTHOUTPUTSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("msSmoothOutputSettings").build();
    private static final MarshallingInfo<StructuredPojo> UDPOUTPUTSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("udpOutputSettings").build();
    private static final OutputSettingsMarshaller instance = new OutputSettingsMarshaller();

    public static OutputSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(OutputSettings outputSettings, ProtocolMarshaller protocolMarshaller) {
        if (outputSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(outputSettings.getArchiveOutputSettings(), ARCHIVEOUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall(outputSettings.getHlsOutputSettings(), HLSOUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall(outputSettings.getMsSmoothOutputSettings(), MSSMOOTHOUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall(outputSettings.getUdpOutputSettings(), UDPOUTPUTSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

