/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.medialive.model.Mp2Settings;

@SdkInternalApi
public class Mp2SettingsMarshaller {
    private static final MarshallingInfo<Double> BITRATE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").build();
    private static final MarshallingInfo<Double> SAMPLERATE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final Mp2SettingsMarshaller instance = new Mp2SettingsMarshaller();

    public static Mp2SettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Mp2Settings mp2Settings, ProtocolMarshaller protocolMarshaller) {
        if (mp2Settings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(mp2Settings.getBitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall(mp2Settings.getCodingMode(), CODINGMODE_BINDING);
            protocolMarshaller.marshall(mp2Settings.getSampleRate(), SAMPLERATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

