/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.LaunchTemplateConfig;
import com.amazonaws.services.ec2.model.LaunchTemplateOverrides;
import com.amazonaws.services.ec2.model.transform.FleetLaunchTemplateSpecificationStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.LaunchTemplateOverridesStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class LaunchTemplateConfigStaxUnmarshaller
implements Unmarshaller<LaunchTemplateConfig, StaxUnmarshallerContext> {
    private static LaunchTemplateConfigStaxUnmarshaller instance;

    @Override
    public LaunchTemplateConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchTemplateConfig launchTemplateConfig = new LaunchTemplateConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return launchTemplateConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("launchTemplateSpecification", targetDepth)) {
                    launchTemplateConfig.setLaunchTemplateSpecification(FleetLaunchTemplateSpecificationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("overrides", targetDepth)) {
                    launchTemplateConfig.withOverrides(new ArrayList<LaunchTemplateOverrides>());
                    continue;
                }
                if (!context.testExpression("overrides/item", targetDepth)) continue;
                launchTemplateConfig.withOverrides(LaunchTemplateOverridesStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return launchTemplateConfig;
    }

    public static LaunchTemplateConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LaunchTemplateConfigStaxUnmarshaller();
        }
        return instance;
    }
}

