/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.transform.EnvironmentImageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnvironmentImage
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private List<String> versions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EnvironmentImage withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public EnvironmentImage withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public void setVersions(Collection<String> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        this.versions = new ArrayList<String>(versions);
    }

    public EnvironmentImage withVersions(String ... versions) {
        if (this.versions == null) {
            this.setVersions(new ArrayList<String>(versions.length));
        }
        for (String ele : versions) {
            this.versions.add(ele);
        }
        return this;
    }

    public EnvironmentImage withVersions(Collection<String> versions) {
        this.setVersions(versions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getVersions() != null) {
            sb.append("Versions: ").append(this.getVersions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentImage)) {
            return false;
        }
        EnvironmentImage other = (EnvironmentImage)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        return other.getVersions() == null || other.getVersions().equals(this.getVersions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        return hashCode;
    }

    public EnvironmentImage clone() {
        try {
            return (EnvironmentImage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

