/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.Projection;
import java.util.List;

public class ProjectionJsonMarshaller {
    private static ProjectionJsonMarshaller instance;

    public void marshall(Projection projection, StructuredJsonGenerator jsonGenerator) {
        if (projection == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> nonKeyAttributesList;
            jsonGenerator.writeStartObject();
            if (projection.getProjectionType() != null) {
                jsonGenerator.writeFieldName("ProjectionType").writeValue(projection.getProjectionType());
            }
            if ((nonKeyAttributesList = projection.getNonKeyAttributes()) != null) {
                jsonGenerator.writeFieldName("NonKeyAttributes");
                jsonGenerator.writeStartArray();
                for (String nonKeyAttributesListValue : nonKeyAttributesList) {
                    if (nonKeyAttributesListValue == null) continue;
                    jsonGenerator.writeValue(nonKeyAttributesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ProjectionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ProjectionJsonMarshaller();
        }
        return instance;
    }
}

