/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;

public interface DynamoDBTypeConverterFactory<S, T> {
    public DynamoDBTypeConverter<S, T> getConverter(Class<S> var1, Class<T> var2);

    @NotThreadSafe
    public static class OverrideFactory<S, T>
    extends DelegateFactory<S, T> {
        private final Map<Map.Entry<Class<S>, Class<T>>, DynamoDBTypeConverter<S, T>> overrides = new LinkedHashMap<Map.Entry<Class<S>, Class<T>>, DynamoDBTypeConverter<S, T>>();

        public OverrideFactory(DynamoDBTypeConverterFactory<S, T> delegate) {
            super(delegate);
        }

        public <s extends S, t extends T> OverrideFactory<S, T> with(Class<s> sourceType, Class<t> targetType, DynamoDBTypeConverter<s, t> converter) {
            this.overrides.put(new AbstractMap.SimpleImmutableEntry<Class<s>, Class<t>>(sourceType, targetType), converter);
            return this;
        }

        @Override
        public DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            for (Map.Entry<Map.Entry<Class<S>, Class<T>>, DynamoDBTypeConverter<S, T>> entry : this.overrides.entrySet()) {
                if (!entry.getKey().getKey().isAssignableFrom(sourceType) || !entry.getKey().getValue().isAssignableFrom(targetType)) continue;
                return entry.getValue();
            }
            return super.getConverter(sourceType, targetType);
        }
    }

    public static class DelegateFactory<S, T>
    implements DynamoDBTypeConverterFactory<S, T> {
        private static final DynamoDBTypeConverterFactory<?, ?> NIL = new DynamoDBTypeConverterFactory<Object, Object>(){

            @Override
            public final DynamoDBTypeConverter<Object, Object> getConverter(Class<Object> sourceType, Class<Object> targetType) {
                return null;
            }
        };
        private final DynamoDBTypeConverterFactory<S, T> delegate;

        public DelegateFactory(DynamoDBTypeConverterFactory<S, T> delegate) {
            this.delegate = delegate == null ? NIL : delegate;
        }

        @Override
        public DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            return this.delegate.getConverter(sourceType, targetType);
        }
    }
}

