/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeConfiguration;
import com.amazonaws.services.simpleworkflow.model.transform.TaskListJsonMarshaller;

public class ActivityTypeConfigurationJsonMarshaller {
    private static ActivityTypeConfigurationJsonMarshaller instance;

    public void marshall(ActivityTypeConfiguration activityTypeConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (activityTypeConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (activityTypeConfiguration.getDefaultTaskStartToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskStartToCloseTimeout").writeValue(activityTypeConfiguration.getDefaultTaskStartToCloseTimeout());
            }
            if (activityTypeConfiguration.getDefaultTaskHeartbeatTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskHeartbeatTimeout").writeValue(activityTypeConfiguration.getDefaultTaskHeartbeatTimeout());
            }
            if (activityTypeConfiguration.getDefaultTaskList() != null) {
                jsonGenerator.writeFieldName("defaultTaskList");
                TaskListJsonMarshaller.getInstance().marshall(activityTypeConfiguration.getDefaultTaskList(), jsonGenerator);
            }
            if (activityTypeConfiguration.getDefaultTaskPriority() != null) {
                jsonGenerator.writeFieldName("defaultTaskPriority").writeValue(activityTypeConfiguration.getDefaultTaskPriority());
            }
            if (activityTypeConfiguration.getDefaultTaskScheduleToStartTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskScheduleToStartTimeout").writeValue(activityTypeConfiguration.getDefaultTaskScheduleToStartTimeout());
            }
            if (activityTypeConfiguration.getDefaultTaskScheduleToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskScheduleToCloseTimeout").writeValue(activityTypeConfiguration.getDefaultTaskScheduleToCloseTimeout());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActivityTypeConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActivityTypeConfigurationJsonMarshaller();
        }
        return instance;
    }
}

