/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.GetDomainSuggestionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetDomainSuggestionsRequestMarshaller
implements Marshaller<Request<GetDomainSuggestionsRequest>, GetDomainSuggestionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetDomainSuggestionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDomainSuggestionsRequest> marshall(GetDomainSuggestionsRequest getDomainSuggestionsRequest) {
        if (getDomainSuggestionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDomainSuggestionsRequest> request = new DefaultRequest<GetDomainSuggestionsRequest>(getDomainSuggestionsRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.GetDomainSuggestions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getDomainSuggestionsRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(getDomainSuggestionsRequest.getDomainName());
            }
            if (getDomainSuggestionsRequest.getSuggestionCount() != null) {
                jsonGenerator.writeFieldName("SuggestionCount").writeValue(getDomainSuggestionsRequest.getSuggestionCount());
            }
            if (getDomainSuggestionsRequest.getOnlyAvailable() != null) {
                jsonGenerator.writeFieldName("OnlyAvailable").writeValue(getDomainSuggestionsRequest.getOnlyAvailable());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

