/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class CreateResourceRequestMarshaller
implements Marshaller<Request<CreateResourceRequest>, CreateResourceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateResourceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateResourceRequest> marshall(CreateResourceRequest createResourceRequest) {
        if (createResourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateResourceRequest> request = new DefaultRequest<CreateResourceRequest>(createResourceRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{parent_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createResourceRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(createResourceRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{parent_id}", createResourceRequest.getParentId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(createResourceRequest.getParentId()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createResourceRequest.getPathPart() != null) {
                jsonGenerator.writeFieldName("pathPart").writeValue(createResourceRequest.getPathPart());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

