/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsResult;
import com.amazonaws.services.rds.waiters.DBInstanceAvailable;
import com.amazonaws.services.rds.waiters.DBInstanceDeleted;
import com.amazonaws.services.rds.waiters.DBSnapshotAvailable;
import com.amazonaws.services.rds.waiters.DBSnapshotDeleted;
import com.amazonaws.services.rds.waiters.DescribeDBInstancesFunction;
import com.amazonaws.services.rds.waiters.DescribeDBSnapshotsFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonRDSWaiters {
    private final AmazonRDS client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonRDSWaiters(AmazonRDS client) {
        this.client = client;
    }

    public Waiter<DescribeDBInstancesRequest> dBInstanceAvailable() {
        return new WaiterBuilder<DescribeDBInstancesRequest, DescribeDBInstancesResult>().withSdkFunction(new DescribeDBInstancesFunction(this.client)).withAcceptors(new DBInstanceAvailable.IsAvailableMatcher(), new DBInstanceAvailable.IsDeletedMatcher(), new DBInstanceAvailable.IsDeletingMatcher(), new DBInstanceAvailable.IsFailedMatcher(), new DBInstanceAvailable.IsIncompatiblerestoreMatcher(), new DBInstanceAvailable.IsIncompatibleparametersMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBSnapshotsRequest> dBSnapshotAvailable() {
        return new WaiterBuilder<DescribeDBSnapshotsRequest, DescribeDBSnapshotsResult>().withSdkFunction(new DescribeDBSnapshotsFunction(this.client)).withAcceptors(new DBSnapshotAvailable.IsAvailableMatcher(), new DBSnapshotAvailable.IsDeletedMatcher(), new DBSnapshotAvailable.IsDeletingMatcher(), new DBSnapshotAvailable.IsFailedMatcher(), new DBSnapshotAvailable.IsIncompatiblerestoreMatcher(), new DBSnapshotAvailable.IsIncompatibleparametersMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBSnapshotsRequest> dBSnapshotDeleted() {
        return new WaiterBuilder<DescribeDBSnapshotsRequest, DescribeDBSnapshotsResult>().withSdkFunction(new DescribeDBSnapshotsFunction(this.client)).withAcceptors(new DBSnapshotDeleted.IsDeletedMatcher(), new DBSnapshotDeleted.IsDBSnapshotNotFoundMatcher(), new DBSnapshotDeleted.IsCreatingMatcher(), new DBSnapshotDeleted.IsModifyingMatcher(), new DBSnapshotDeleted.IsRebootingMatcher(), new DBSnapshotDeleted.IsResettingmastercredentialsMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBInstancesRequest> dBInstanceDeleted() {
        return new WaiterBuilder<DescribeDBInstancesRequest, DescribeDBInstancesResult>().withSdkFunction(new DescribeDBInstancesFunction(this.client)).withAcceptors(new DBInstanceDeleted.IsDeletedMatcher(), new DBInstanceDeleted.IsDBInstanceNotFoundMatcher(), new DBInstanceDeleted.IsCreatingMatcher(), new DBInstanceDeleted.IsModifyingMatcher(), new DBInstanceDeleted.IsRebootingMatcher(), new DBInstanceDeleted.IsResettingmastercredentialsMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

