/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeImagesRequestMarshaller
implements Marshaller<Request<DescribeImagesRequest>, DescribeImagesRequest> {
    @Override
    public Request<DescribeImagesRequest> marshall(DescribeImagesRequest describeImagesRequest) {
        SdkInternalList describeImagesRequestOwnersList;
        SdkInternalList describeImagesRequestImageIdsList;
        SdkInternalList describeImagesRequestFiltersList;
        if (describeImagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeImagesRequest> request = new DefaultRequest<DescribeImagesRequest>(describeImagesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeImages");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeImagesRequestExecutableUsersList = (SdkInternalList)describeImagesRequest.getExecutableUsers();
        if (!describeImagesRequestExecutableUsersList.isEmpty() || !describeImagesRequestExecutableUsersList.isAutoConstruct()) {
            int executableUsersListIndex = 1;
            for (Object describeImagesRequestExecutableUsersListValue : describeImagesRequestExecutableUsersList) {
                if (describeImagesRequestExecutableUsersListValue != null) {
                    request.addParameter("ExecutableBy." + executableUsersListIndex, StringUtils.fromString((String)describeImagesRequestExecutableUsersListValue));
                }
                ++executableUsersListIndex;
            }
        }
        if (!(describeImagesRequestFiltersList = (SdkInternalList)describeImagesRequest.getFilters()).isEmpty() || !describeImagesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describeImagesRequestFiltersListValue : describeImagesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describeImagesRequestFiltersListValue).getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(((Filter)describeImagesRequestFiltersListValue).getName()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describeImagesRequestFiltersListValue).getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeImagesRequestImageIdsList = (SdkInternalList)describeImagesRequest.getImageIds()).isEmpty() || !describeImagesRequestImageIdsList.isAutoConstruct()) {
            int imageIdsListIndex = 1;
            for (String describeImagesRequestImageIdsListValue : describeImagesRequestImageIdsList) {
                if (describeImagesRequestImageIdsListValue != null) {
                    request.addParameter("ImageId." + imageIdsListIndex, StringUtils.fromString(describeImagesRequestImageIdsListValue));
                }
                ++imageIdsListIndex;
            }
        }
        if (!(describeImagesRequestOwnersList = (SdkInternalList)describeImagesRequest.getOwners()).isEmpty() || !describeImagesRequestOwnersList.isAutoConstruct()) {
            int ownersListIndex = 1;
            for (String describeImagesRequestOwnersListValue : describeImagesRequestOwnersList) {
                if (describeImagesRequestOwnersListValue != null) {
                    request.addParameter("Owner." + ownersListIndex, StringUtils.fromString(describeImagesRequestOwnersListValue));
                }
                ++ownersListIndex;
            }
        }
        return request;
    }
}

