/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeNatGatewaysRequestMarshaller
implements Marshaller<Request<DescribeNatGatewaysRequest>, DescribeNatGatewaysRequest> {
    @Override
    public Request<DescribeNatGatewaysRequest> marshall(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        SdkInternalList describeNatGatewaysRequestNatGatewayIdsList;
        if (describeNatGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeNatGatewaysRequest> request = new DefaultRequest<DescribeNatGatewaysRequest>(describeNatGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeNatGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeNatGatewaysRequestFilterList = (SdkInternalList)describeNatGatewaysRequest.getFilter();
        if (!describeNatGatewaysRequestFilterList.isEmpty() || !describeNatGatewaysRequestFilterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter describeNatGatewaysRequestFilterListValue : describeNatGatewaysRequestFilterList) {
                SdkInternalList filterValuesList;
                if (describeNatGatewaysRequestFilterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString(describeNatGatewaysRequestFilterListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeNatGatewaysRequestFilterListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeNatGatewaysRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeNatGatewaysRequest.getMaxResults()));
        }
        if (!(describeNatGatewaysRequestNatGatewayIdsList = (SdkInternalList)describeNatGatewaysRequest.getNatGatewayIds()).isEmpty() || !describeNatGatewaysRequestNatGatewayIdsList.isAutoConstruct()) {
            int natGatewayIdsListIndex = 1;
            for (String describeNatGatewaysRequestNatGatewayIdsListValue : describeNatGatewaysRequestNatGatewayIdsList) {
                if (describeNatGatewaysRequestNatGatewayIdsListValue != null) {
                    request.addParameter("NatGatewayId." + natGatewayIdsListIndex, StringUtils.fromString(describeNatGatewaysRequestNatGatewayIdsListValue));
                }
                ++natGatewayIdsListIndex;
            }
        }
        if (describeNatGatewaysRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeNatGatewaysRequest.getNextToken()));
        }
        return request;
    }
}

