/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;

@SdkInternalApi
final class StandardParameterTypes {
    StandardParameterTypes() {
    }

    static final <T> ParamType<T> of(Type type, Type ... paramTypes) {
        if (type instanceof Class) {
            if (paramTypes.length == 0 && Set.class.isAssignableFrom((Class)type)) {
                paramTypes = new Type[]{Object.class};
            }
            return new ParamType((Class)type, type, paramTypes);
        }
        if (type instanceof ParameterizedType) {
            if (paramTypes.length == 0) {
                paramTypes = ((ParameterizedType)type).getActualTypeArguments();
            }
            return new ParamType((Class)((ParameterizedType)type).getRawType(), type, paramTypes);
        }
        if (type.toString().equals("byte[]")) {
            return new ParamType(byte[].class, type, paramTypes);
        }
        return new ParamType(Object.class, type, paramTypes);
    }

    static final <T> ParamType<T> of(DynamoDBTypeConverter<?, T> converter) {
        if (!converter.getClass().isInterface()) {
            for (Class<?> c = converter.getClass(); Object.class != c; c = c.getSuperclass()) {
                for (Type genericType : c.getGenericInterfaces()) {
                    ParamType<T> t = StandardParameterTypes.of(genericType, new Type[0]);
                    if (!DynamoDBTypeConverter.class.isAssignableFrom(t.type()) || ((ParamType)t).params.length != 2 || t.param(0).type() == Object.class) continue;
                    return t.param(0);
                }
            }
            ParamType<T> t = StandardParameterTypes.of(converter.getClass().getGenericSuperclass(), new Type[0]);
            if (DynamoDBTypeConverter.class.isAssignableFrom(t.type()) && ((ParamType)t).params.length > 0 && t.param(0).type() != Object.class) {
                return t.param(0);
            }
        }
        throw new DynamoDBMappingException("could not resolve type of " + converter.getClass());
    }

    static final class ParamType<T> {
        private final ParamType<T>[] params;
        private final Type genericType;
        private final Class<T> type;

        private ParamType(Class<T> type, Type genericType, Type ... paramTypes) {
            this.params = new ParamType[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                this.params[i] = StandardParameterTypes.of(paramTypes[i], new Type[0]);
            }
            this.genericType = genericType;
            this.type = type;
        }

        final ParamType<T> param(int index) {
            return this.params.length > index ? this.params[index] : null;
        }

        final Class<T> type() {
            return this.type;
        }

        public boolean equals(Object o) {
            return o instanceof ParamType && this.genericType.equals(((ParamType)o).genericType);
        }

        public int hashCode() {
            return this.genericType.hashCode();
        }

        public String toString() {
            return this.genericType.toString();
        }
    }
}

