/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector.model.ResourceGroupTag;
import com.amazonaws.services.inspector.model.transform.ResourceGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ResourceGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private List<ResourceGroupTag> tags;
    private Date createdAt;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ResourceGroup withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<ResourceGroupTag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<ResourceGroupTag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<ResourceGroupTag>(tags);
    }

    public ResourceGroup withTags(ResourceGroupTag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<ResourceGroupTag>(tags.length));
        }
        for (ResourceGroupTag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ResourceGroup withTags(Collection<ResourceGroupTag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public ResourceGroup withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceGroup)) {
            return false;
        }
        ResourceGroup other = (ResourceGroup)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        return other.getCreatedAt() == null || other.getCreatedAt().equals(this.getCreatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        return hashCode;
    }

    public ResourceGroup clone() {
        try {
            return (ResourceGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

