/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.Endpoint;
import com.amazonaws.services.elasticache.model.NodeGroupMember;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class NodeGroup
implements Serializable,
Cloneable {
    private String nodeGroupId;
    private String status;
    private Endpoint primaryEndpoint;
    private SdkInternalList<NodeGroupMember> nodeGroupMembers;

    public void setNodeGroupId(String nodeGroupId) {
        this.nodeGroupId = nodeGroupId;
    }

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public NodeGroup withNodeGroupId(String nodeGroupId) {
        this.setNodeGroupId(nodeGroupId);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public NodeGroup withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setPrimaryEndpoint(Endpoint primaryEndpoint) {
        this.primaryEndpoint = primaryEndpoint;
    }

    public Endpoint getPrimaryEndpoint() {
        return this.primaryEndpoint;
    }

    public NodeGroup withPrimaryEndpoint(Endpoint primaryEndpoint) {
        this.setPrimaryEndpoint(primaryEndpoint);
        return this;
    }

    public List<NodeGroupMember> getNodeGroupMembers() {
        if (this.nodeGroupMembers == null) {
            this.nodeGroupMembers = new SdkInternalList();
        }
        return this.nodeGroupMembers;
    }

    public void setNodeGroupMembers(Collection<NodeGroupMember> nodeGroupMembers) {
        if (nodeGroupMembers == null) {
            this.nodeGroupMembers = null;
            return;
        }
        this.nodeGroupMembers = new SdkInternalList<NodeGroupMember>(nodeGroupMembers);
    }

    public NodeGroup withNodeGroupMembers(NodeGroupMember ... nodeGroupMembers) {
        if (this.nodeGroupMembers == null) {
            this.setNodeGroupMembers(new SdkInternalList<NodeGroupMember>(nodeGroupMembers.length));
        }
        for (NodeGroupMember ele : nodeGroupMembers) {
            this.nodeGroupMembers.add(ele);
        }
        return this;
    }

    public NodeGroup withNodeGroupMembers(Collection<NodeGroupMember> nodeGroupMembers) {
        this.setNodeGroupMembers(nodeGroupMembers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNodeGroupId() != null) {
            sb.append("NodeGroupId: " + this.getNodeGroupId() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getPrimaryEndpoint() != null) {
            sb.append("PrimaryEndpoint: " + this.getPrimaryEndpoint() + ",");
        }
        if (this.getNodeGroupMembers() != null) {
            sb.append("NodeGroupMembers: " + this.getNodeGroupMembers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroup)) {
            return false;
        }
        NodeGroup other = (NodeGroup)obj;
        if (other.getNodeGroupId() == null ^ this.getNodeGroupId() == null) {
            return false;
        }
        if (other.getNodeGroupId() != null && !other.getNodeGroupId().equals(this.getNodeGroupId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPrimaryEndpoint() == null ^ this.getPrimaryEndpoint() == null) {
            return false;
        }
        if (other.getPrimaryEndpoint() != null && !other.getPrimaryEndpoint().equals(this.getPrimaryEndpoint())) {
            return false;
        }
        if (other.getNodeGroupMembers() == null ^ this.getNodeGroupMembers() == null) {
            return false;
        }
        return other.getNodeGroupMembers() == null || other.getNodeGroupMembers().equals(this.getNodeGroupMembers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNodeGroupId() == null ? 0 : this.getNodeGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryEndpoint() == null ? 0 : this.getPrimaryEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getNodeGroupMembers() == null ? 0 : this.getNodeGroupMembers().hashCode());
        return hashCode;
    }

    public NodeGroup clone() {
        try {
            return (NodeGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

