/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.ContainerInstance;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.services.ecs.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.ResourceJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VersionInfoJsonMarshaller;

public class ContainerInstanceJsonMarshaller {
    private static ContainerInstanceJsonMarshaller instance;

    public void marshall(ContainerInstance containerInstance, StructuredJsonGenerator jsonGenerator) {
        if (containerInstance == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList attributesList;
            SdkInternalList registeredResourcesList;
            SdkInternalList remainingResourcesList;
            jsonGenerator.writeStartObject();
            if (containerInstance.getContainerInstanceArn() != null) {
                jsonGenerator.writeFieldName("containerInstanceArn").writeValue(containerInstance.getContainerInstanceArn());
            }
            if (containerInstance.getEc2InstanceId() != null) {
                jsonGenerator.writeFieldName("ec2InstanceId").writeValue(containerInstance.getEc2InstanceId());
            }
            if (containerInstance.getVersionInfo() != null) {
                jsonGenerator.writeFieldName("versionInfo");
                VersionInfoJsonMarshaller.getInstance().marshall(containerInstance.getVersionInfo(), jsonGenerator);
            }
            if (!(remainingResourcesList = (SdkInternalList)containerInstance.getRemainingResources()).isEmpty() || !remainingResourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("remainingResources");
                jsonGenerator.writeStartArray();
                for (Object remainingResourcesListValue : remainingResourcesList) {
                    if (remainingResourcesListValue == null) continue;
                    ResourceJsonMarshaller.getInstance().marshall((Resource)remainingResourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(registeredResourcesList = (SdkInternalList)containerInstance.getRegisteredResources()).isEmpty() || !registeredResourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("registeredResources");
                jsonGenerator.writeStartArray();
                for (Resource registeredResourcesListValue : registeredResourcesList) {
                    if (registeredResourcesListValue == null) continue;
                    ResourceJsonMarshaller.getInstance().marshall(registeredResourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerInstance.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(containerInstance.getStatus());
            }
            if (containerInstance.getAgentConnected() != null) {
                jsonGenerator.writeFieldName("agentConnected").writeValue(containerInstance.getAgentConnected());
            }
            if (containerInstance.getRunningTasksCount() != null) {
                jsonGenerator.writeFieldName("runningTasksCount").writeValue(containerInstance.getRunningTasksCount());
            }
            if (containerInstance.getPendingTasksCount() != null) {
                jsonGenerator.writeFieldName("pendingTasksCount").writeValue(containerInstance.getPendingTasksCount());
            }
            if (containerInstance.getAgentUpdateStatus() != null) {
                jsonGenerator.writeFieldName("agentUpdateStatus").writeValue(containerInstance.getAgentUpdateStatus());
            }
            if (!(attributesList = (SdkInternalList)containerInstance.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerInstanceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerInstanceJsonMarshaller();
        }
        return instance;
    }
}

