/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDocument;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBFlattened;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshalling;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBNativeBoolean;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SdkInternalApi
final class StandardAnnotationMaps {
    StandardAnnotationMaps() {
    }

    static final <T> TableMap<T> of(Class<T> clazz) {
        DynamoDBMapperTableModel.Properties.Builder<T> defaults = new DynamoDBMapperTableModel.Properties.Builder<T>();
        defaults.withTargetType(clazz);
        TableMap map = new TableMap(defaults);
        map.putAll(clazz);
        return map;
    }

    static final <T> FieldMap<T> of(Method getter) {
        DynamoDBMapperFieldModel.Properties.Builder defaults = new DynamoDBMapperFieldModel.Properties.Builder();
        defaults.withAttributeName(StandardBeanProperties.nameOf(getter, null));
        defaults.withTargetType(getter.getReturnType());
        FieldMap map = new FieldMap(defaults);
        map.putAll(getter.getReturnType());
        map.putAll(StandardBeanProperties.declaredFieldOf(getter));
        map.putAll(getter);
        return map;
    }

    static final class FieldMap<T>
    extends AnnotationMap<T>
    implements DynamoDBMapperFieldModel.Properties<T> {
        private final DynamoDBMapperFieldModel.Properties<T> defaults;

        private FieldMap(DynamoDBMapperFieldModel.Properties<T> defaults) {
            this.defaults = defaults;
        }

        final Annotation autoGenerated() {
            return this.get(DynamoDBAutoGenerated.class, true);
        }

        final DynamoDBAttribute attribute() {
            return this.get(DynamoDBAttribute.class);
        }

        final DynamoDBFlattened flattened() {
            return this.get(DynamoDBFlattened.class);
        }

        final DynamoDBHashKey hashKey() {
            return this.get(DynamoDBHashKey.class);
        }

        final DynamoDBIgnore ignore() {
            return this.get(DynamoDBIgnore.class);
        }

        final DynamoDBIndexHashKey indexHashKey() {
            return this.get(DynamoDBIndexHashKey.class);
        }

        final DynamoDBIndexRangeKey indexRangeKey() {
            return this.get(DynamoDBIndexRangeKey.class);
        }

        final DynamoDBMarshalling marshalling() {
            return this.get(DynamoDBMarshalling.class);
        }

        final DynamoDBNativeBoolean nativeBoolean() {
            return this.get(DynamoDBNativeBoolean.class);
        }

        final DynamoDBRangeKey rangeKey() {
            return this.get(DynamoDBRangeKey.class);
        }

        final DynamoDBVersionAttribute version() {
            return this.get(DynamoDBVersionAttribute.class);
        }

        final boolean ignored() {
            return this.ignore() != null;
        }

        final Map<String, String> attributes() {
            if (this.flattened() != null) {
                if (this.flattened().attributes().length == 0) {
                    throw new DynamoDBMappingException("must specify one or more attributes");
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (DynamoDBAttribute a : this.flattened().attributes()) {
                    if (a.mappedBy().isEmpty() || a.attributeName().isEmpty()) {
                        throw new DynamoDBMappingException("must specify mappedBy and attributeName");
                    }
                    if (attributes.put(a.mappedBy(), a.attributeName()) == null) continue;
                    throw new DynamoDBMappingException("must not duplicate mappedBy=" + a.mappedBy());
                }
                return attributes;
            }
            return Collections.emptyMap();
        }

        @Override
        public Class<T> targetType() {
            return this.defaults.targetType();
        }

        @Override
        public final String attributeName() {
            if (this.hashKey() != null && !this.hashKey().attributeName().isEmpty()) {
                return this.hashKey().attributeName();
            }
            if (this.indexHashKey() != null && !this.indexHashKey().attributeName().isEmpty()) {
                return this.indexHashKey().attributeName();
            }
            if (this.rangeKey() != null && !this.rangeKey().attributeName().isEmpty()) {
                return this.rangeKey().attributeName();
            }
            if (this.indexRangeKey() != null && !this.indexRangeKey().attributeName().isEmpty()) {
                return this.indexRangeKey().attributeName();
            }
            if (this.attribute() != null && !this.attribute().attributeName().isEmpty()) {
                return this.attribute().attributeName();
            }
            if (this.version() != null && !this.version().attributeName().isEmpty()) {
                return this.version().attributeName();
            }
            return this.defaults.attributeName();
        }

        @Override
        public final KeyType keyType() {
            return this.hashKey() != null ? KeyType.HASH : (this.rangeKey() != null ? KeyType.RANGE : this.defaults.keyType());
        }

        @Override
        public final List<String> globalSecondaryIndexNames(KeyType keyType) {
            if (keyType == KeyType.HASH && this.indexHashKey() != null) {
                if (!this.indexHashKey().globalSecondaryIndexName().isEmpty()) {
                    if (this.indexHashKey().globalSecondaryIndexNames().length > 0) {
                        throw new DynamoDBMappingException("must not specify both HASH GSI name/names");
                    }
                    return Collections.singletonList(this.indexHashKey().globalSecondaryIndexName());
                }
                if (this.indexHashKey().globalSecondaryIndexNames().length > 0) {
                    return Collections.unmodifiableList(Arrays.asList(this.indexHashKey().globalSecondaryIndexNames()));
                }
                throw new DynamoDBMappingException("must specify one of HASH GSI name/names");
            }
            if (keyType == KeyType.RANGE && this.indexRangeKey() != null) {
                if (!this.indexRangeKey().globalSecondaryIndexName().isEmpty()) {
                    if (this.indexRangeKey().globalSecondaryIndexNames().length > 0) {
                        throw new DynamoDBMappingException("must not specify both RANGE GSI name/names");
                    }
                    return Collections.singletonList(this.indexRangeKey().globalSecondaryIndexName());
                }
                if (this.indexRangeKey().globalSecondaryIndexNames().length > 0) {
                    return Collections.unmodifiableList(Arrays.asList(this.indexRangeKey().globalSecondaryIndexNames()));
                }
                if (this.localSecondaryIndexNames().isEmpty()) {
                    throw new DynamoDBMappingException("must specify RANGE GSI and/or LSI name/names");
                }
            }
            return this.defaults.globalSecondaryIndexNames(keyType);
        }

        @Override
        public final List<String> localSecondaryIndexNames() {
            if (this.indexRangeKey() != null) {
                if (!this.indexRangeKey().localSecondaryIndexName().isEmpty()) {
                    if (this.indexRangeKey().localSecondaryIndexNames().length > 0) {
                        throw new DynamoDBMappingException("must not specify both LSI name/names");
                    }
                    return Collections.singletonList(this.indexRangeKey().localSecondaryIndexName());
                }
                if (this.indexRangeKey().localSecondaryIndexNames().length > 0) {
                    return Collections.unmodifiableList(Arrays.asList(this.indexRangeKey().localSecondaryIndexNames()));
                }
            }
            return this.defaults.localSecondaryIndexNames();
        }

        @Override
        public final DynamoDBAutoGenerator<T> autoGenerator() {
            Annotation annotation = this.autoGenerated();
            if (annotation != null) {
                DynamoDBAutoGenerated generated = this.get(DynamoDBAutoGenerated.class);
                try {
                    if (annotation != generated) {
                        try {
                            return generated.generator().getConstructor(Class.class, annotation.annotationType()).newInstance(this.targetType(), annotation);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    try {
                        return generated.generator().getConstructor(Class.class).newInstance(this.targetType());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return generated.generator().newInstance();
                    }
                }
                catch (Exception e) {
                    throw new DynamoDBMappingException("could not create generator: " + annotation, e);
                }
            }
            return this.defaults.autoGenerator();
        }
    }

    static final class TableMap<T>
    extends AnnotationMap<T>
    implements DynamoDBMapperTableModel.Properties<T> {
        private final DynamoDBMapperTableModel.Properties<T> defaults;

        private TableMap(DynamoDBMapperTableModel.Properties<T> defaults) {
            this.defaults = defaults;
        }

        final DynamoDBDocument document() {
            return this.get(DynamoDBDocument.class);
        }

        final DynamoDBTable table() {
            return this.get(DynamoDBTable.class);
        }

        final boolean typed() {
            return this.table() != null || this.document() != null;
        }

        @Override
        public Class<T> targetType() {
            return this.defaults.targetType();
        }

        @Override
        public final String tableName() {
            return this.table() != null ? this.table().tableName() : this.defaults.tableName();
        }
    }

    static abstract class AnnotationMap<T> {
        private final Map<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();

        AnnotationMap() {
        }

        final AnnotationMap putAll(AnnotatedElement annotated) {
            if (annotated != null && annotated.getAnnotations().length > 0) {
                HashMap<Class<? extends Annotation>, Annotation> tmp = new HashMap<Class<? extends Annotation>, Annotation>();
                for (Annotation a1 : annotated.getAnnotations()) {
                    if (a1.annotationType().isAnnotationPresent(DynamoDB.class)) {
                        if (tmp.containsKey(a1.annotationType())) {
                            throw new DynamoDBMappingException("conflicting annotations " + a1 + " and " + tmp.get(a1.annotationType()) + "; allowed only one of @" + a1.annotationType().getSimpleName());
                        }
                        tmp.put(a1.annotationType(), a1);
                    }
                    for (Annotation a2 : a1.annotationType().getAnnotations()) {
                        if (!a2.annotationType().isAnnotationPresent(DynamoDB.class)) continue;
                        if (tmp.containsKey(a2.annotationType())) {
                            throw new DynamoDBMappingException("conflicting annotations " + a1 + " and " + tmp.get(a2.annotationType()) + "; allowed only one of @" + a2.annotationType().getSimpleName());
                        }
                        tmp.put(a2.annotationType(), a1);
                    }
                }
                this.map.putAll(tmp);
            }
            return this;
        }

        final boolean has(Class<? extends Annotation> ... annotationTypes) {
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                if (this.get(annotationType, true) == null) continue;
                return true;
            }
            return false;
        }

        final <A extends Annotation> A get(Class<A> annotationType, boolean mappedBy) {
            Annotation annotation = this.map.get(annotationType);
            if (!mappedBy && annotation != null && annotation.annotationType() != annotationType) {
                return annotation.annotationType().getAnnotation(annotationType);
            }
            return (A)annotation;
        }

        final <A extends Annotation> A get(Class<A> annotationType) {
            return this.get(annotationType, false);
        }
    }
}

