/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudfront.AmazonCloudFrontAsync;
import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.CreateDistributionRequest;
import com.amazonaws.services.cloudfront.model.CreateDistributionResult;
import com.amazonaws.services.cloudfront.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront.model.CreateInvalidationResult;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.DeleteDistributionRequest;
import com.amazonaws.services.cloudfront.model.DeleteDistributionResult;
import com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResult;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionResult;
import com.amazonaws.services.cloudfront.model.GetInvalidationRequest;
import com.amazonaws.services.cloudfront.model.GetInvalidationResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResult;
import com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest;
import com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdResult;
import com.amazonaws.services.cloudfront.model.ListDistributionsRequest;
import com.amazonaws.services.cloudfront.model.ListDistributionsResult;
import com.amazonaws.services.cloudfront.model.ListInvalidationsRequest;
import com.amazonaws.services.cloudfront.model.ListInvalidationsResult;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsResult;
import com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.UpdateDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateDistributionResult;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudFrontAsyncClient
extends AmazonCloudFrontClient
implements AmazonCloudFrontAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonCloudFrontAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudFrontAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFrontAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFrontAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonCloudFrontAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonCloudFrontAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateCloudFrontOriginAccessIdentityResult> createCloudFrontOriginAccessIdentityAsync(CreateCloudFrontOriginAccessIdentityRequest request) {
        return this.createCloudFrontOriginAccessIdentityAsync(request, null);
    }

    @Override
    public Future<CreateCloudFrontOriginAccessIdentityResult> createCloudFrontOriginAccessIdentityAsync(final CreateCloudFrontOriginAccessIdentityRequest request, final AsyncHandler<CreateCloudFrontOriginAccessIdentityRequest, CreateCloudFrontOriginAccessIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateCloudFrontOriginAccessIdentityResult>(){

            @Override
            public CreateCloudFrontOriginAccessIdentityResult call() throws Exception {
                CreateCloudFrontOriginAccessIdentityResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.createCloudFrontOriginAccessIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDistributionResult> createDistributionAsync(CreateDistributionRequest request) {
        return this.createDistributionAsync(request, null);
    }

    @Override
    public Future<CreateDistributionResult> createDistributionAsync(final CreateDistributionRequest request, final AsyncHandler<CreateDistributionRequest, CreateDistributionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDistributionResult>(){

            @Override
            public CreateDistributionResult call() throws Exception {
                CreateDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.createDistribution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInvalidationResult> createInvalidationAsync(CreateInvalidationRequest request) {
        return this.createInvalidationAsync(request, null);
    }

    @Override
    public Future<CreateInvalidationResult> createInvalidationAsync(final CreateInvalidationRequest request, final AsyncHandler<CreateInvalidationRequest, CreateInvalidationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateInvalidationResult>(){

            @Override
            public CreateInvalidationResult call() throws Exception {
                CreateInvalidationResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.createInvalidation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamingDistributionResult> createStreamingDistributionAsync(CreateStreamingDistributionRequest request) {
        return this.createStreamingDistributionAsync(request, null);
    }

    @Override
    public Future<CreateStreamingDistributionResult> createStreamingDistributionAsync(final CreateStreamingDistributionRequest request, final AsyncHandler<CreateStreamingDistributionRequest, CreateStreamingDistributionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateStreamingDistributionResult>(){

            @Override
            public CreateStreamingDistributionResult call() throws Exception {
                CreateStreamingDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.createStreamingDistribution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCloudFrontOriginAccessIdentityResult> deleteCloudFrontOriginAccessIdentityAsync(DeleteCloudFrontOriginAccessIdentityRequest request) {
        return this.deleteCloudFrontOriginAccessIdentityAsync(request, null);
    }

    @Override
    public Future<DeleteCloudFrontOriginAccessIdentityResult> deleteCloudFrontOriginAccessIdentityAsync(final DeleteCloudFrontOriginAccessIdentityRequest request, final AsyncHandler<DeleteCloudFrontOriginAccessIdentityRequest, DeleteCloudFrontOriginAccessIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCloudFrontOriginAccessIdentityResult>(){

            @Override
            public DeleteCloudFrontOriginAccessIdentityResult call() throws Exception {
                DeleteCloudFrontOriginAccessIdentityResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.deleteCloudFrontOriginAccessIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDistributionResult> deleteDistributionAsync(DeleteDistributionRequest request) {
        return this.deleteDistributionAsync(request, null);
    }

    @Override
    public Future<DeleteDistributionResult> deleteDistributionAsync(final DeleteDistributionRequest request, final AsyncHandler<DeleteDistributionRequest, DeleteDistributionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDistributionResult>(){

            @Override
            public DeleteDistributionResult call() throws Exception {
                DeleteDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.deleteDistribution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStreamingDistributionResult> deleteStreamingDistributionAsync(DeleteStreamingDistributionRequest request) {
        return this.deleteStreamingDistributionAsync(request, null);
    }

    @Override
    public Future<DeleteStreamingDistributionResult> deleteStreamingDistributionAsync(final DeleteStreamingDistributionRequest request, final AsyncHandler<DeleteStreamingDistributionRequest, DeleteStreamingDistributionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteStreamingDistributionResult>(){

            @Override
            public DeleteStreamingDistributionResult call() throws Exception {
                DeleteStreamingDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.deleteStreamingDistribution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityResult> getCloudFrontOriginAccessIdentityAsync(GetCloudFrontOriginAccessIdentityRequest request) {
        return this.getCloudFrontOriginAccessIdentityAsync(request, null);
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityResult> getCloudFrontOriginAccessIdentityAsync(final GetCloudFrontOriginAccessIdentityRequest request, final AsyncHandler<GetCloudFrontOriginAccessIdentityRequest, GetCloudFrontOriginAccessIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCloudFrontOriginAccessIdentityResult>(){

            @Override
            public GetCloudFrontOriginAccessIdentityResult call() throws Exception {
                GetCloudFrontOriginAccessIdentityResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getCloudFrontOriginAccessIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityConfigResult> getCloudFrontOriginAccessIdentityConfigAsync(GetCloudFrontOriginAccessIdentityConfigRequest request) {
        return this.getCloudFrontOriginAccessIdentityConfigAsync(request, null);
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityConfigResult> getCloudFrontOriginAccessIdentityConfigAsync(final GetCloudFrontOriginAccessIdentityConfigRequest request, final AsyncHandler<GetCloudFrontOriginAccessIdentityConfigRequest, GetCloudFrontOriginAccessIdentityConfigResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCloudFrontOriginAccessIdentityConfigResult>(){

            @Override
            public GetCloudFrontOriginAccessIdentityConfigResult call() throws Exception {
                GetCloudFrontOriginAccessIdentityConfigResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getCloudFrontOriginAccessIdentityConfig(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDistributionResult> getDistributionAsync(GetDistributionRequest request) {
        return this.getDistributionAsync(request, null);
    }

    @Override
    public Future<GetDistributionResult> getDistributionAsync(final GetDistributionRequest request, final AsyncHandler<GetDistributionRequest, GetDistributionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDistributionResult>(){

            @Override
            public GetDistributionResult call() throws Exception {
                GetDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getDistribution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDistributionConfigResult> getDistributionConfigAsync(GetDistributionConfigRequest request) {
        return this.getDistributionConfigAsync(request, null);
    }

    @Override
    public Future<GetDistributionConfigResult> getDistributionConfigAsync(final GetDistributionConfigRequest request, final AsyncHandler<GetDistributionConfigRequest, GetDistributionConfigResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDistributionConfigResult>(){

            @Override
            public GetDistributionConfigResult call() throws Exception {
                GetDistributionConfigResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getDistributionConfig(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInvalidationResult> getInvalidationAsync(GetInvalidationRequest request) {
        return this.getInvalidationAsync(request, null);
    }

    @Override
    public Future<GetInvalidationResult> getInvalidationAsync(final GetInvalidationRequest request, final AsyncHandler<GetInvalidationRequest, GetInvalidationResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetInvalidationResult>(){

            @Override
            public GetInvalidationResult call() throws Exception {
                GetInvalidationResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getInvalidation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStreamingDistributionResult> getStreamingDistributionAsync(GetStreamingDistributionRequest request) {
        return this.getStreamingDistributionAsync(request, null);
    }

    @Override
    public Future<GetStreamingDistributionResult> getStreamingDistributionAsync(final GetStreamingDistributionRequest request, final AsyncHandler<GetStreamingDistributionRequest, GetStreamingDistributionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetStreamingDistributionResult>(){

            @Override
            public GetStreamingDistributionResult call() throws Exception {
                GetStreamingDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getStreamingDistribution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStreamingDistributionConfigResult> getStreamingDistributionConfigAsync(GetStreamingDistributionConfigRequest request) {
        return this.getStreamingDistributionConfigAsync(request, null);
    }

    @Override
    public Future<GetStreamingDistributionConfigResult> getStreamingDistributionConfigAsync(final GetStreamingDistributionConfigRequest request, final AsyncHandler<GetStreamingDistributionConfigRequest, GetStreamingDistributionConfigResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetStreamingDistributionConfigResult>(){

            @Override
            public GetStreamingDistributionConfigResult call() throws Exception {
                GetStreamingDistributionConfigResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getStreamingDistributionConfig(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCloudFrontOriginAccessIdentitiesResult> listCloudFrontOriginAccessIdentitiesAsync(ListCloudFrontOriginAccessIdentitiesRequest request) {
        return this.listCloudFrontOriginAccessIdentitiesAsync(request, null);
    }

    @Override
    public Future<ListCloudFrontOriginAccessIdentitiesResult> listCloudFrontOriginAccessIdentitiesAsync(final ListCloudFrontOriginAccessIdentitiesRequest request, final AsyncHandler<ListCloudFrontOriginAccessIdentitiesRequest, ListCloudFrontOriginAccessIdentitiesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCloudFrontOriginAccessIdentitiesResult>(){

            @Override
            public ListCloudFrontOriginAccessIdentitiesResult call() throws Exception {
                ListCloudFrontOriginAccessIdentitiesResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.listCloudFrontOriginAccessIdentities(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDistributionsResult> listDistributionsAsync(ListDistributionsRequest request) {
        return this.listDistributionsAsync(request, null);
    }

    @Override
    public Future<ListDistributionsResult> listDistributionsAsync(final ListDistributionsRequest request, final AsyncHandler<ListDistributionsRequest, ListDistributionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDistributionsResult>(){

            @Override
            public ListDistributionsResult call() throws Exception {
                ListDistributionsResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.listDistributions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDistributionsByWebACLIdResult> listDistributionsByWebACLIdAsync(ListDistributionsByWebACLIdRequest request) {
        return this.listDistributionsByWebACLIdAsync(request, null);
    }

    @Override
    public Future<ListDistributionsByWebACLIdResult> listDistributionsByWebACLIdAsync(final ListDistributionsByWebACLIdRequest request, final AsyncHandler<ListDistributionsByWebACLIdRequest, ListDistributionsByWebACLIdResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDistributionsByWebACLIdResult>(){

            @Override
            public ListDistributionsByWebACLIdResult call() throws Exception {
                ListDistributionsByWebACLIdResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.listDistributionsByWebACLId(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInvalidationsResult> listInvalidationsAsync(ListInvalidationsRequest request) {
        return this.listInvalidationsAsync(request, null);
    }

    @Override
    public Future<ListInvalidationsResult> listInvalidationsAsync(final ListInvalidationsRequest request, final AsyncHandler<ListInvalidationsRequest, ListInvalidationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListInvalidationsResult>(){

            @Override
            public ListInvalidationsResult call() throws Exception {
                ListInvalidationsResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.listInvalidations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamingDistributionsResult> listStreamingDistributionsAsync(ListStreamingDistributionsRequest request) {
        return this.listStreamingDistributionsAsync(request, null);
    }

    @Override
    public Future<ListStreamingDistributionsResult> listStreamingDistributionsAsync(final ListStreamingDistributionsRequest request, final AsyncHandler<ListStreamingDistributionsRequest, ListStreamingDistributionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStreamingDistributionsResult>(){

            @Override
            public ListStreamingDistributionsResult call() throws Exception {
                ListStreamingDistributionsResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.listStreamingDistributions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCloudFrontOriginAccessIdentityResult> updateCloudFrontOriginAccessIdentityAsync(UpdateCloudFrontOriginAccessIdentityRequest request) {
        return this.updateCloudFrontOriginAccessIdentityAsync(request, null);
    }

    @Override
    public Future<UpdateCloudFrontOriginAccessIdentityResult> updateCloudFrontOriginAccessIdentityAsync(final UpdateCloudFrontOriginAccessIdentityRequest request, final AsyncHandler<UpdateCloudFrontOriginAccessIdentityRequest, UpdateCloudFrontOriginAccessIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateCloudFrontOriginAccessIdentityResult>(){

            @Override
            public UpdateCloudFrontOriginAccessIdentityResult call() throws Exception {
                UpdateCloudFrontOriginAccessIdentityResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.updateCloudFrontOriginAccessIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDistributionResult> updateDistributionAsync(UpdateDistributionRequest request) {
        return this.updateDistributionAsync(request, null);
    }

    @Override
    public Future<UpdateDistributionResult> updateDistributionAsync(final UpdateDistributionRequest request, final AsyncHandler<UpdateDistributionRequest, UpdateDistributionResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateDistributionResult>(){

            @Override
            public UpdateDistributionResult call() throws Exception {
                UpdateDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.updateDistribution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStreamingDistributionResult> updateStreamingDistributionAsync(UpdateStreamingDistributionRequest request) {
        return this.updateStreamingDistributionAsync(request, null);
    }

    @Override
    public Future<UpdateStreamingDistributionResult> updateStreamingDistributionAsync(final UpdateStreamingDistributionRequest request, final AsyncHandler<UpdateStreamingDistributionRequest, UpdateStreamingDistributionResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateStreamingDistributionResult>(){

            @Override
            public UpdateStreamingDistributionResult call() throws Exception {
                UpdateStreamingDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.updateStreamingDistribution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

