/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.CreateAssessmentTemplateRequest;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateAssessmentTemplateRequestMarshaller
implements Marshaller<Request<CreateAssessmentTemplateRequest>, CreateAssessmentTemplateRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateAssessmentTemplateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateAssessmentTemplateRequest> marshall(CreateAssessmentTemplateRequest createAssessmentTemplateRequest) {
        if (createAssessmentTemplateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAssessmentTemplateRequest> request = new DefaultRequest<CreateAssessmentTemplateRequest>(createAssessmentTemplateRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.CreateAssessmentTemplate");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Attribute> userAttributesForFindingsList;
            List<String> rulesPackageArnsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createAssessmentTemplateRequest.getAssessmentTargetArn() != null) {
                jsonGenerator.writeFieldName("assessmentTargetArn").writeValue(createAssessmentTemplateRequest.getAssessmentTargetArn());
            }
            if (createAssessmentTemplateRequest.getAssessmentTemplateName() != null) {
                jsonGenerator.writeFieldName("assessmentTemplateName").writeValue(createAssessmentTemplateRequest.getAssessmentTemplateName());
            }
            if (createAssessmentTemplateRequest.getDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("durationInSeconds").writeValue(createAssessmentTemplateRequest.getDurationInSeconds());
            }
            if ((rulesPackageArnsList = createAssessmentTemplateRequest.getRulesPackageArns()) != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String string : rulesPackageArnsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((userAttributesForFindingsList = createAssessmentTemplateRequest.getUserAttributesForFindings()) != null) {
                jsonGenerator.writeFieldName("userAttributesForFindings");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesForFindingsListValue : userAttributesForFindingsList) {
                    if (userAttributesForFindingsListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesForFindingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

