/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.SetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.VaultNotificationConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.List;

public class SetVaultNotificationsRequestMarshaller
implements Marshaller<Request<SetVaultNotificationsRequest>, SetVaultNotificationsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetVaultNotificationsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SetVaultNotificationsRequest> marshall(SetVaultNotificationsRequest setVaultNotificationsRequest) {
        if (setVaultNotificationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetVaultNotificationsRequest> request = new DefaultRequest<SetVaultNotificationsRequest>(setVaultNotificationsRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/notification-configuration";
        uriResourcePath = uriResourcePath.replace("{accountId}", setVaultNotificationsRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(setVaultNotificationsRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", setVaultNotificationsRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(setVaultNotificationsRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            VaultNotificationConfig vaultNotificationConfig = setVaultNotificationsRequest.getVaultNotificationConfig();
            if (vaultNotificationConfig != null) {
                List<String> eventsList;
                jsonGenerator.writeStartObject();
                if (vaultNotificationConfig.getSNSTopic() != null) {
                    jsonGenerator.writeFieldName("SNSTopic").writeValue(vaultNotificationConfig.getSNSTopic());
                }
                if ((eventsList = vaultNotificationConfig.getEvents()) != null) {
                    jsonGenerator.writeFieldName("Events");
                    jsonGenerator.writeStartArray();
                    for (String eventsListValue : eventsList) {
                        if (eventsListValue == null) continue;
                        jsonGenerator.writeValue(eventsListValue);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

