/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public final class EC2CredentialsUtils {
    private static final Log LOG = LogFactory.getLog(EC2CredentialsUtils.class);
    private static final int RETRY_COUNT = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readResource(URI endpoint) throws IOException {
        URL url = endpoint.toURL();
        int retries = 0;
        InputStream inputStream = null;
        while (true) {
            try {
                while (true) {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout(2000);
                    connection.setReadTimeout(5000);
                    connection.setRequestMethod("GET");
                    connection.setDoOutput(true);
                    connection.connect();
                    int statusCode = connection.getResponseCode();
                    if (statusCode == 200) {
                        inputStream = connection.getInputStream();
                        String string = IOUtils.toString(inputStream);
                        IOUtils.closeQuietly(inputStream, LOG);
                        return string;
                    }
                    if (statusCode == 404) {
                        throw new AmazonClientException("The requested metadata is not found at " + connection.getURL());
                    }
                    if (statusCode >= 500 && statusCode < 600 && retries++ < 5) {
                        IOUtils.closeQuietly(inputStream, LOG);
                        continue;
                    }
                    inputStream = connection.getErrorStream();
                    EC2CredentialsUtils.handleErrorResponse(inputStream, statusCode, connection.getResponseMessage());
                    IOUtils.closeQuietly(inputStream, LOG);
                }
            }
            catch (IOException ioException) {
                if (retries++ >= 5) {
                    throw ioException;
                }
                LOG.debug((Object)("An IOException occured when connecting to service endpoint: " + url.toString() + "\n Retrying to connect again."));
                continue;
            }
            finally {
                IOUtils.closeQuietly(inputStream, LOG);
                continue;
            }
            break;
        }
    }

    private static void handleErrorResponse(InputStream errorStream, int statusCode, String responseMessage) throws IOException {
        String errorCode = null;
        if (errorStream != null) {
            String errorResponse = IOUtils.toString(errorStream);
            try {
                JsonNode node = Jackson.jsonNodeOf(errorResponse);
                JsonNode code = node.get("code");
                JsonNode message = node.get("message");
                if (code != null && message != null) {
                    errorCode = code.asText();
                    responseMessage = message.asText();
                }
            }
            catch (Exception exception) {
                LOG.debug((Object)"Unable to parse error stream");
            }
        }
        AmazonServiceException ase = new AmazonServiceException(responseMessage);
        ase.setStatusCode(statusCode);
        ase.setErrorCode(errorCode);
        throw ase;
    }
}

