/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.GameSessionQueueDestination;
import com.amazonaws.services.gamelift.model.PlayerLatencyPolicy;
import com.amazonaws.services.gamelift.model.transform.GameSessionQueueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GameSessionQueue
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String gameSessionQueueArn;
    private Integer timeoutInSeconds;
    private List<PlayerLatencyPolicy> playerLatencyPolicies;
    private List<GameSessionQueueDestination> destinations;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GameSessionQueue withName(String name) {
        this.setName(name);
        return this;
    }

    public void setGameSessionQueueArn(String gameSessionQueueArn) {
        this.gameSessionQueueArn = gameSessionQueueArn;
    }

    public String getGameSessionQueueArn() {
        return this.gameSessionQueueArn;
    }

    public GameSessionQueue withGameSessionQueueArn(String gameSessionQueueArn) {
        this.setGameSessionQueueArn(gameSessionQueueArn);
        return this;
    }

    public void setTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public GameSessionQueue withTimeoutInSeconds(Integer timeoutInSeconds) {
        this.setTimeoutInSeconds(timeoutInSeconds);
        return this;
    }

    public List<PlayerLatencyPolicy> getPlayerLatencyPolicies() {
        return this.playerLatencyPolicies;
    }

    public void setPlayerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
        if (playerLatencyPolicies == null) {
            this.playerLatencyPolicies = null;
            return;
        }
        this.playerLatencyPolicies = new ArrayList<PlayerLatencyPolicy>(playerLatencyPolicies);
    }

    public GameSessionQueue withPlayerLatencyPolicies(PlayerLatencyPolicy ... playerLatencyPolicies) {
        if (this.playerLatencyPolicies == null) {
            this.setPlayerLatencyPolicies(new ArrayList<PlayerLatencyPolicy>(playerLatencyPolicies.length));
        }
        for (PlayerLatencyPolicy ele : playerLatencyPolicies) {
            this.playerLatencyPolicies.add(ele);
        }
        return this;
    }

    public GameSessionQueue withPlayerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
        this.setPlayerLatencyPolicies(playerLatencyPolicies);
        return this;
    }

    public List<GameSessionQueueDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<GameSessionQueueDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<GameSessionQueueDestination>(destinations);
    }

    public GameSessionQueue withDestinations(GameSessionQueueDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<GameSessionQueueDestination>(destinations.length));
        }
        for (GameSessionQueueDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public GameSessionQueue withDestinations(Collection<GameSessionQueueDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getGameSessionQueueArn() != null) {
            sb.append("GameSessionQueueArn: ").append(this.getGameSessionQueueArn()).append(",");
        }
        if (this.getTimeoutInSeconds() != null) {
            sb.append("TimeoutInSeconds: ").append(this.getTimeoutInSeconds()).append(",");
        }
        if (this.getPlayerLatencyPolicies() != null) {
            sb.append("PlayerLatencyPolicies: ").append(this.getPlayerLatencyPolicies()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionQueue)) {
            return false;
        }
        GameSessionQueue other = (GameSessionQueue)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getGameSessionQueueArn() == null ^ this.getGameSessionQueueArn() == null) {
            return false;
        }
        if (other.getGameSessionQueueArn() != null && !other.getGameSessionQueueArn().equals(this.getGameSessionQueueArn())) {
            return false;
        }
        if (other.getTimeoutInSeconds() == null ^ this.getTimeoutInSeconds() == null) {
            return false;
        }
        if (other.getTimeoutInSeconds() != null && !other.getTimeoutInSeconds().equals(this.getTimeoutInSeconds())) {
            return false;
        }
        if (other.getPlayerLatencyPolicies() == null ^ this.getPlayerLatencyPolicies() == null) {
            return false;
        }
        if (other.getPlayerLatencyPolicies() != null && !other.getPlayerLatencyPolicies().equals(this.getPlayerLatencyPolicies())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        return other.getDestinations() == null || other.getDestinations().equals(this.getDestinations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionQueueArn() == null ? 0 : this.getGameSessionQueueArn().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInSeconds() == null ? 0 : this.getTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getPlayerLatencyPolicies() == null ? 0 : this.getPlayerLatencyPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        return hashCode;
    }

    public GameSessionQueue clone() {
        try {
            return (GameSessionQueue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionQueueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

