/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.PlatformStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PlatformSummary
implements Serializable,
Cloneable {
    private String platformArn;
    private String platformOwner;
    private String platformStatus;
    private String platformCategory;
    private String operatingSystemName;
    private String operatingSystemVersion;
    private SdkInternalList<String> supportedTierList;
    private SdkInternalList<String> supportedAddonList;

    public void setPlatformArn(String platformArn) {
        this.platformArn = platformArn;
    }

    public String getPlatformArn() {
        return this.platformArn;
    }

    public PlatformSummary withPlatformArn(String platformArn) {
        this.setPlatformArn(platformArn);
        return this;
    }

    public void setPlatformOwner(String platformOwner) {
        this.platformOwner = platformOwner;
    }

    public String getPlatformOwner() {
        return this.platformOwner;
    }

    public PlatformSummary withPlatformOwner(String platformOwner) {
        this.setPlatformOwner(platformOwner);
        return this;
    }

    public void setPlatformStatus(String platformStatus) {
        this.platformStatus = platformStatus;
    }

    public String getPlatformStatus() {
        return this.platformStatus;
    }

    public PlatformSummary withPlatformStatus(String platformStatus) {
        this.setPlatformStatus(platformStatus);
        return this;
    }

    public void setPlatformStatus(PlatformStatus platformStatus) {
        this.withPlatformStatus(platformStatus);
    }

    public PlatformSummary withPlatformStatus(PlatformStatus platformStatus) {
        this.platformStatus = platformStatus.toString();
        return this;
    }

    public void setPlatformCategory(String platformCategory) {
        this.platformCategory = platformCategory;
    }

    public String getPlatformCategory() {
        return this.platformCategory;
    }

    public PlatformSummary withPlatformCategory(String platformCategory) {
        this.setPlatformCategory(platformCategory);
        return this;
    }

    public void setOperatingSystemName(String operatingSystemName) {
        this.operatingSystemName = operatingSystemName;
    }

    public String getOperatingSystemName() {
        return this.operatingSystemName;
    }

    public PlatformSummary withOperatingSystemName(String operatingSystemName) {
        this.setOperatingSystemName(operatingSystemName);
        return this;
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public PlatformSummary withOperatingSystemVersion(String operatingSystemVersion) {
        this.setOperatingSystemVersion(operatingSystemVersion);
        return this;
    }

    public List<String> getSupportedTierList() {
        if (this.supportedTierList == null) {
            this.supportedTierList = new SdkInternalList();
        }
        return this.supportedTierList;
    }

    public void setSupportedTierList(Collection<String> supportedTierList) {
        if (supportedTierList == null) {
            this.supportedTierList = null;
            return;
        }
        this.supportedTierList = new SdkInternalList<String>(supportedTierList);
    }

    public PlatformSummary withSupportedTierList(String ... supportedTierList) {
        if (this.supportedTierList == null) {
            this.setSupportedTierList(new SdkInternalList<String>(supportedTierList.length));
        }
        for (String ele : supportedTierList) {
            this.supportedTierList.add(ele);
        }
        return this;
    }

    public PlatformSummary withSupportedTierList(Collection<String> supportedTierList) {
        this.setSupportedTierList(supportedTierList);
        return this;
    }

    public List<String> getSupportedAddonList() {
        if (this.supportedAddonList == null) {
            this.supportedAddonList = new SdkInternalList();
        }
        return this.supportedAddonList;
    }

    public void setSupportedAddonList(Collection<String> supportedAddonList) {
        if (supportedAddonList == null) {
            this.supportedAddonList = null;
            return;
        }
        this.supportedAddonList = new SdkInternalList<String>(supportedAddonList);
    }

    public PlatformSummary withSupportedAddonList(String ... supportedAddonList) {
        if (this.supportedAddonList == null) {
            this.setSupportedAddonList(new SdkInternalList<String>(supportedAddonList.length));
        }
        for (String ele : supportedAddonList) {
            this.supportedAddonList.add(ele);
        }
        return this;
    }

    public PlatformSummary withSupportedAddonList(Collection<String> supportedAddonList) {
        this.setSupportedAddonList(supportedAddonList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlatformArn() != null) {
            sb.append("PlatformArn: ").append(this.getPlatformArn()).append(",");
        }
        if (this.getPlatformOwner() != null) {
            sb.append("PlatformOwner: ").append(this.getPlatformOwner()).append(",");
        }
        if (this.getPlatformStatus() != null) {
            sb.append("PlatformStatus: ").append(this.getPlatformStatus()).append(",");
        }
        if (this.getPlatformCategory() != null) {
            sb.append("PlatformCategory: ").append(this.getPlatformCategory()).append(",");
        }
        if (this.getOperatingSystemName() != null) {
            sb.append("OperatingSystemName: ").append(this.getOperatingSystemName()).append(",");
        }
        if (this.getOperatingSystemVersion() != null) {
            sb.append("OperatingSystemVersion: ").append(this.getOperatingSystemVersion()).append(",");
        }
        if (this.getSupportedTierList() != null) {
            sb.append("SupportedTierList: ").append(this.getSupportedTierList()).append(",");
        }
        if (this.getSupportedAddonList() != null) {
            sb.append("SupportedAddonList: ").append(this.getSupportedAddonList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformSummary)) {
            return false;
        }
        PlatformSummary other = (PlatformSummary)obj;
        if (other.getPlatformArn() == null ^ this.getPlatformArn() == null) {
            return false;
        }
        if (other.getPlatformArn() != null && !other.getPlatformArn().equals(this.getPlatformArn())) {
            return false;
        }
        if (other.getPlatformOwner() == null ^ this.getPlatformOwner() == null) {
            return false;
        }
        if (other.getPlatformOwner() != null && !other.getPlatformOwner().equals(this.getPlatformOwner())) {
            return false;
        }
        if (other.getPlatformStatus() == null ^ this.getPlatformStatus() == null) {
            return false;
        }
        if (other.getPlatformStatus() != null && !other.getPlatformStatus().equals(this.getPlatformStatus())) {
            return false;
        }
        if (other.getPlatformCategory() == null ^ this.getPlatformCategory() == null) {
            return false;
        }
        if (other.getPlatformCategory() != null && !other.getPlatformCategory().equals(this.getPlatformCategory())) {
            return false;
        }
        if (other.getOperatingSystemName() == null ^ this.getOperatingSystemName() == null) {
            return false;
        }
        if (other.getOperatingSystemName() != null && !other.getOperatingSystemName().equals(this.getOperatingSystemName())) {
            return false;
        }
        if (other.getOperatingSystemVersion() == null ^ this.getOperatingSystemVersion() == null) {
            return false;
        }
        if (other.getOperatingSystemVersion() != null && !other.getOperatingSystemVersion().equals(this.getOperatingSystemVersion())) {
            return false;
        }
        if (other.getSupportedTierList() == null ^ this.getSupportedTierList() == null) {
            return false;
        }
        if (other.getSupportedTierList() != null && !other.getSupportedTierList().equals(this.getSupportedTierList())) {
            return false;
        }
        if (other.getSupportedAddonList() == null ^ this.getSupportedAddonList() == null) {
            return false;
        }
        return other.getSupportedAddonList() == null || other.getSupportedAddonList().equals(this.getSupportedAddonList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlatformArn() == null ? 0 : this.getPlatformArn().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformOwner() == null ? 0 : this.getPlatformOwner().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformStatus() == null ? 0 : this.getPlatformStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformCategory() == null ? 0 : this.getPlatformCategory().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystemName() == null ? 0 : this.getOperatingSystemName().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystemVersion() == null ? 0 : this.getOperatingSystemVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedTierList() == null ? 0 : this.getSupportedTierList().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedAddonList() == null ? 0 : this.getSupportedAddonList().hashCode());
        return hashCode;
    }

    public PlatformSummary clone() {
        try {
            return (PlatformSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

