/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BatchGetApplicationRevisionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private SdkInternalList<RevisionLocation> revisions;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public BatchGetApplicationRevisionsRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public List<RevisionLocation> getRevisions() {
        if (this.revisions == null) {
            this.revisions = new SdkInternalList();
        }
        return this.revisions;
    }

    public void setRevisions(Collection<RevisionLocation> revisions) {
        if (revisions == null) {
            this.revisions = null;
            return;
        }
        this.revisions = new SdkInternalList<RevisionLocation>(revisions);
    }

    public BatchGetApplicationRevisionsRequest withRevisions(RevisionLocation ... revisions) {
        if (this.revisions == null) {
            this.setRevisions(new SdkInternalList<RevisionLocation>(revisions.length));
        }
        for (RevisionLocation ele : revisions) {
            this.revisions.add(ele);
        }
        return this;
    }

    public BatchGetApplicationRevisionsRequest withRevisions(Collection<RevisionLocation> revisions) {
        this.setRevisions(revisions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getRevisions() != null) {
            sb.append("Revisions: ").append(this.getRevisions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsRequest)) {
            return false;
        }
        BatchGetApplicationRevisionsRequest other = (BatchGetApplicationRevisionsRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getRevisions() == null ^ this.getRevisions() == null) {
            return false;
        }
        return other.getRevisions() == null || other.getRevisions().equals(this.getRevisions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getRevisions() == null ? 0 : this.getRevisions().hashCode());
        return hashCode;
    }

    @Override
    public BatchGetApplicationRevisionsRequest clone() {
        return (BatchGetApplicationRevisionsRequest)super.clone();
    }
}

