/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.budgets.model.ComparisonOperator;
import com.amazonaws.services.budgets.model.NotificationType;
import com.amazonaws.services.budgets.model.transform.NotificationMarshaller;
import java.io.Serializable;

public class Notification
implements Serializable,
Cloneable,
StructuredPojo {
    private String notificationType;
    private String comparisonOperator;
    private Double threshold;

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public Notification withNotificationType(String notificationType) {
        this.setNotificationType(notificationType);
        return this;
    }

    public void setNotificationType(NotificationType notificationType) {
        this.withNotificationType(notificationType);
    }

    public Notification withNotificationType(NotificationType notificationType) {
        this.notificationType = notificationType.toString();
        return this;
    }

    public void setComparisonOperator(String comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
    }

    public String getComparisonOperator() {
        return this.comparisonOperator;
    }

    public Notification withComparisonOperator(String comparisonOperator) {
        this.setComparisonOperator(comparisonOperator);
        return this;
    }

    public void setComparisonOperator(ComparisonOperator comparisonOperator) {
        this.withComparisonOperator(comparisonOperator);
    }

    public Notification withComparisonOperator(ComparisonOperator comparisonOperator) {
        this.comparisonOperator = comparisonOperator.toString();
        return this;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public Notification withThreshold(Double threshold) {
        this.setThreshold(threshold);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNotificationType() != null) {
            sb.append("NotificationType: ").append(this.getNotificationType()).append(",");
        }
        if (this.getComparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.getComparisonOperator()).append(",");
        }
        if (this.getThreshold() != null) {
            sb.append("Threshold: ").append(this.getThreshold());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        if (other.getNotificationType() == null ^ this.getNotificationType() == null) {
            return false;
        }
        if (other.getNotificationType() != null && !other.getNotificationType().equals(this.getNotificationType())) {
            return false;
        }
        if (other.getComparisonOperator() == null ^ this.getComparisonOperator() == null) {
            return false;
        }
        if (other.getComparisonOperator() != null && !other.getComparisonOperator().equals(this.getComparisonOperator())) {
            return false;
        }
        if (other.getThreshold() == null ^ this.getThreshold() == null) {
            return false;
        }
        return other.getThreshold() == null || other.getThreshold().equals(this.getThreshold());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNotificationType() == null ? 0 : this.getNotificationType().hashCode());
        hashCode = 31 * hashCode + (this.getComparisonOperator() == null ? 0 : this.getComparisonOperator().hashCode());
        hashCode = 31 * hashCode + (this.getThreshold() == null ? 0 : this.getThreshold().hashCode());
        return hashCode;
    }

    public Notification clone() {
        try {
            return (Notification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

