/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.VolumeAttachment;
import com.amazonaws.services.ec2.model.VolumeState;
import com.amazonaws.services.ec2.model.VolumeType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Volume
implements Serializable,
Cloneable {
    private SdkInternalList<VolumeAttachment> attachments;
    private String availabilityZone;
    private Date createTime;
    private Boolean encrypted;
    private String kmsKeyId;
    private Integer size;
    private String snapshotId;
    private String state;
    private String volumeId;
    private Integer iops;
    private SdkInternalList<Tag> tags;
    private String volumeType;

    public List<VolumeAttachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new SdkInternalList();
        }
        return this.attachments;
    }

    public void setAttachments(Collection<VolumeAttachment> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        this.attachments = new SdkInternalList<VolumeAttachment>(attachments);
    }

    public Volume withAttachments(VolumeAttachment ... attachments) {
        if (this.attachments == null) {
            this.setAttachments(new SdkInternalList<VolumeAttachment>(attachments.length));
        }
        for (VolumeAttachment ele : attachments) {
            this.attachments.add(ele);
        }
        return this;
    }

    public Volume withAttachments(Collection<VolumeAttachment> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Volume withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Volume withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public Volume withEncrypted(Boolean encrypted) {
        this.setEncrypted(encrypted);
        return this;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Volume withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public Volume withSize(Integer size) {
        this.setSize(size);
        return this;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public Volume withSnapshotId(String snapshotId) {
        this.setSnapshotId(snapshotId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Volume withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(VolumeState state) {
        this.withState(state);
    }

    public Volume withState(VolumeState state) {
        this.state = state.toString();
        return this;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public Volume withVolumeId(String volumeId) {
        this.setVolumeId(volumeId);
        return this;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public Integer getIops() {
        return this.iops;
    }

    public Volume withIops(Integer iops) {
        this.setIops(iops);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public Volume withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Volume withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVolumeType(String volumeType) {
        this.volumeType = volumeType;
    }

    public String getVolumeType() {
        return this.volumeType;
    }

    public Volume withVolumeType(String volumeType) {
        this.setVolumeType(volumeType);
        return this;
    }

    public void setVolumeType(VolumeType volumeType) {
        this.withVolumeType(volumeType);
    }

    public Volume withVolumeType(VolumeType volumeType) {
        this.volumeType = volumeType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttachments() != null) {
            sb.append("Attachments: ").append(this.getAttachments()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getEncrypted() != null) {
            sb.append("Encrypted: ").append(this.getEncrypted()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getSize() != null) {
            sb.append("Size: ").append(this.getSize()).append(",");
        }
        if (this.getSnapshotId() != null) {
            sb.append("SnapshotId: ").append(this.getSnapshotId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getVolumeId() != null) {
            sb.append("VolumeId: ").append(this.getVolumeId()).append(",");
        }
        if (this.getIops() != null) {
            sb.append("Iops: ").append(this.getIops()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVolumeType() != null) {
            sb.append("VolumeType: ").append(this.getVolumeType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        if (other.getAttachments() != null && !other.getAttachments().equals(this.getAttachments())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getEncrypted() == null ^ this.getEncrypted() == null) {
            return false;
        }
        if (other.getEncrypted() != null && !other.getEncrypted().equals(this.getEncrypted())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getSize() == null ^ this.getSize() == null) {
            return false;
        }
        if (other.getSize() != null && !other.getSize().equals(this.getSize())) {
            return false;
        }
        if (other.getSnapshotId() == null ^ this.getSnapshotId() == null) {
            return false;
        }
        if (other.getSnapshotId() != null && !other.getSnapshotId().equals(this.getSnapshotId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getVolumeId() == null ^ this.getVolumeId() == null) {
            return false;
        }
        if (other.getVolumeId() != null && !other.getVolumeId().equals(this.getVolumeId())) {
            return false;
        }
        if (other.getIops() == null ^ this.getIops() == null) {
            return false;
        }
        if (other.getIops() != null && !other.getIops().equals(this.getIops())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVolumeType() == null ^ this.getVolumeType() == null) {
            return false;
        }
        return other.getVolumeType() == null || other.getVolumeType().equals(this.getVolumeType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : this.getAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getEncrypted() == null ? 0 : this.getEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getSize() == null ? 0 : this.getSize().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotId() == null ? 0 : this.getSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeId() == null ? 0 : this.getVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getIops() == null ? 0 : this.getIops().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeType() == null ? 0 : this.getVolumeType().hashCode());
        return hashCode;
    }

    public Volume clone() {
        try {
            return (Volume)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

