/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.services.kinesis.model.AddTagsToStreamResult;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.CreateStreamResult;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.DeleteStreamRequest;
import com.amazonaws.services.kinesis.model.DeleteStreamResult;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.DisableEnhancedMonitoringRequest;
import com.amazonaws.services.kinesis.model.DisableEnhancedMonitoringResult;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringRequest;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringResult;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.ListStreamsRequest;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.services.kinesis.model.ListTagsForStreamResult;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.services.kinesis.model.MergeShardsResult;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamRequest;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamResult;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.amazonaws.services.kinesis.model.SplitShardResult;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisAsyncClient
extends AmazonKinesisClient
implements AmazonKinesisAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonKinesisAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonKinesisAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonKinesisAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonKinesisAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonKinesisAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonKinesisAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsToStreamResult> addTagsToStreamAsync(AddTagsToStreamRequest request) {
        return this.addTagsToStreamAsync(request, null);
    }

    @Override
    public Future<AddTagsToStreamResult> addTagsToStreamAsync(final AddTagsToStreamRequest request, final AsyncHandler<AddTagsToStreamRequest, AddTagsToStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsToStreamResult>(){

            @Override
            public AddTagsToStreamResult call() throws Exception {
                AddTagsToStreamResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.addTagsToStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(CreateStreamRequest request) {
        return this.createStreamAsync(request, null);
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(final CreateStreamRequest request, final AsyncHandler<CreateStreamRequest, CreateStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateStreamResult>(){

            @Override
            public CreateStreamResult call() throws Exception {
                CreateStreamResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.createStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(String streamName, Integer shardCount) {
        return this.createStreamAsync(new CreateStreamRequest().withStreamName(streamName).withShardCount(shardCount));
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(String streamName, Integer shardCount, AsyncHandler<CreateStreamRequest, CreateStreamResult> asyncHandler) {
        return this.createStreamAsync(new CreateStreamRequest().withStreamName(streamName).withShardCount(shardCount), asyncHandler);
    }

    @Override
    public Future<DecreaseStreamRetentionPeriodResult> decreaseStreamRetentionPeriodAsync(DecreaseStreamRetentionPeriodRequest request) {
        return this.decreaseStreamRetentionPeriodAsync(request, null);
    }

    @Override
    public Future<DecreaseStreamRetentionPeriodResult> decreaseStreamRetentionPeriodAsync(final DecreaseStreamRetentionPeriodRequest request, final AsyncHandler<DecreaseStreamRetentionPeriodRequest, DecreaseStreamRetentionPeriodResult> asyncHandler) {
        return this.executorService.submit(new Callable<DecreaseStreamRetentionPeriodResult>(){

            @Override
            public DecreaseStreamRetentionPeriodResult call() throws Exception {
                DecreaseStreamRetentionPeriodResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.decreaseStreamRetentionPeriod(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(DeleteStreamRequest request) {
        return this.deleteStreamAsync(request, null);
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(final DeleteStreamRequest request, final AsyncHandler<DeleteStreamRequest, DeleteStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteStreamResult>(){

            @Override
            public DeleteStreamResult call() throws Exception {
                DeleteStreamResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.deleteStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(String streamName) {
        return this.deleteStreamAsync(new DeleteStreamRequest().withStreamName(streamName));
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(String streamName, AsyncHandler<DeleteStreamRequest, DeleteStreamResult> asyncHandler) {
        return this.deleteStreamAsync(new DeleteStreamRequest().withStreamName(streamName), asyncHandler);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(DescribeStreamRequest request) {
        return this.describeStreamAsync(request, null);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(final DescribeStreamRequest request, final AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStreamResult>(){

            @Override
            public DescribeStreamResult call() throws Exception {
                DescribeStreamResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.describeStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName));
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName), asyncHandler);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, String exclusiveStartShardId) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName).withExclusiveStartShardId(exclusiveStartShardId));
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, String exclusiveStartShardId, AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName).withExclusiveStartShardId(exclusiveStartShardId), asyncHandler);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, Integer limit, String exclusiveStartShardId) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName).withLimit(limit).withExclusiveStartShardId(exclusiveStartShardId));
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, Integer limit, String exclusiveStartShardId, AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName).withLimit(limit).withExclusiveStartShardId(exclusiveStartShardId), asyncHandler);
    }

    @Override
    public Future<DisableEnhancedMonitoringResult> disableEnhancedMonitoringAsync(DisableEnhancedMonitoringRequest request) {
        return this.disableEnhancedMonitoringAsync(request, null);
    }

    @Override
    public Future<DisableEnhancedMonitoringResult> disableEnhancedMonitoringAsync(final DisableEnhancedMonitoringRequest request, final AsyncHandler<DisableEnhancedMonitoringRequest, DisableEnhancedMonitoringResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableEnhancedMonitoringResult>(){

            @Override
            public DisableEnhancedMonitoringResult call() throws Exception {
                DisableEnhancedMonitoringResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.disableEnhancedMonitoring(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableEnhancedMonitoringResult> enableEnhancedMonitoringAsync(EnableEnhancedMonitoringRequest request) {
        return this.enableEnhancedMonitoringAsync(request, null);
    }

    @Override
    public Future<EnableEnhancedMonitoringResult> enableEnhancedMonitoringAsync(final EnableEnhancedMonitoringRequest request, final AsyncHandler<EnableEnhancedMonitoringRequest, EnableEnhancedMonitoringResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableEnhancedMonitoringResult>(){

            @Override
            public EnableEnhancedMonitoringResult call() throws Exception {
                EnableEnhancedMonitoringResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.enableEnhancedMonitoring(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(GetRecordsRequest request) {
        return this.getRecordsAsync(request, null);
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(final GetRecordsRequest request, final AsyncHandler<GetRecordsRequest, GetRecordsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRecordsResult>(){

            @Override
            public GetRecordsResult call() throws Exception {
                GetRecordsResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.getRecords(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(GetShardIteratorRequest request) {
        return this.getShardIteratorAsync(request, null);
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(final GetShardIteratorRequest request, final AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetShardIteratorResult>(){

            @Override
            public GetShardIteratorResult call() throws Exception {
                GetShardIteratorResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.getShardIterator(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(String streamName, String shardId, String shardIteratorType) {
        return this.getShardIteratorAsync(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType));
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(String streamName, String shardId, String shardIteratorType, AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) {
        return this.getShardIteratorAsync(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType), asyncHandler);
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(String streamName, String shardId, String shardIteratorType, String startingSequenceNumber) {
        return this.getShardIteratorAsync(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType).withStartingSequenceNumber(startingSequenceNumber));
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(String streamName, String shardId, String shardIteratorType, String startingSequenceNumber, AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) {
        return this.getShardIteratorAsync(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType).withStartingSequenceNumber(startingSequenceNumber), asyncHandler);
    }

    @Override
    public Future<IncreaseStreamRetentionPeriodResult> increaseStreamRetentionPeriodAsync(IncreaseStreamRetentionPeriodRequest request) {
        return this.increaseStreamRetentionPeriodAsync(request, null);
    }

    @Override
    public Future<IncreaseStreamRetentionPeriodResult> increaseStreamRetentionPeriodAsync(final IncreaseStreamRetentionPeriodRequest request, final AsyncHandler<IncreaseStreamRetentionPeriodRequest, IncreaseStreamRetentionPeriodResult> asyncHandler) {
        return this.executorService.submit(new Callable<IncreaseStreamRetentionPeriodResult>(){

            @Override
            public IncreaseStreamRetentionPeriodResult call() throws Exception {
                IncreaseStreamRetentionPeriodResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.increaseStreamRetentionPeriod(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request) {
        return this.listStreamsAsync(request, null);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(final ListStreamsRequest request, final AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() throws Exception {
                ListStreamsResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.listStreams(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync() {
        return this.listStreamsAsync(new ListStreamsRequest());
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        return this.listStreamsAsync(new ListStreamsRequest(), asyncHandler);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(String exclusiveStartStreamName) {
        return this.listStreamsAsync(new ListStreamsRequest().withExclusiveStartStreamName(exclusiveStartStreamName));
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(String exclusiveStartStreamName, AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        return this.listStreamsAsync(new ListStreamsRequest().withExclusiveStartStreamName(exclusiveStartStreamName), asyncHandler);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(Integer limit, String exclusiveStartStreamName) {
        return this.listStreamsAsync(new ListStreamsRequest().withLimit(limit).withExclusiveStartStreamName(exclusiveStartStreamName));
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(Integer limit, String exclusiveStartStreamName, AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        return this.listStreamsAsync(new ListStreamsRequest().withLimit(limit).withExclusiveStartStreamName(exclusiveStartStreamName), asyncHandler);
    }

    @Override
    public Future<ListTagsForStreamResult> listTagsForStreamAsync(ListTagsForStreamRequest request) {
        return this.listTagsForStreamAsync(request, null);
    }

    @Override
    public Future<ListTagsForStreamResult> listTagsForStreamAsync(final ListTagsForStreamRequest request, final AsyncHandler<ListTagsForStreamRequest, ListTagsForStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForStreamResult>(){

            @Override
            public ListTagsForStreamResult call() throws Exception {
                ListTagsForStreamResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.listTagsForStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<MergeShardsResult> mergeShardsAsync(MergeShardsRequest request) {
        return this.mergeShardsAsync(request, null);
    }

    @Override
    public Future<MergeShardsResult> mergeShardsAsync(final MergeShardsRequest request, final AsyncHandler<MergeShardsRequest, MergeShardsResult> asyncHandler) {
        return this.executorService.submit(new Callable<MergeShardsResult>(){

            @Override
            public MergeShardsResult call() throws Exception {
                MergeShardsResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.mergeShards(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<MergeShardsResult> mergeShardsAsync(String streamName, String shardToMerge, String adjacentShardToMerge) {
        return this.mergeShardsAsync(new MergeShardsRequest().withStreamName(streamName).withShardToMerge(shardToMerge).withAdjacentShardToMerge(adjacentShardToMerge));
    }

    @Override
    public Future<MergeShardsResult> mergeShardsAsync(String streamName, String shardToMerge, String adjacentShardToMerge, AsyncHandler<MergeShardsRequest, MergeShardsResult> asyncHandler) {
        return this.mergeShardsAsync(new MergeShardsRequest().withStreamName(streamName).withShardToMerge(shardToMerge).withAdjacentShardToMerge(adjacentShardToMerge), asyncHandler);
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(PutRecordRequest request) {
        return this.putRecordAsync(request, null);
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(final PutRecordRequest request, final AsyncHandler<PutRecordRequest, PutRecordResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutRecordResult>(){

            @Override
            public PutRecordResult call() throws Exception {
                PutRecordResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.putRecord(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(String streamName, ByteBuffer data, String partitionKey) {
        return this.putRecordAsync(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey));
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(String streamName, ByteBuffer data, String partitionKey, AsyncHandler<PutRecordRequest, PutRecordResult> asyncHandler) {
        return this.putRecordAsync(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey), asyncHandler);
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(String streamName, ByteBuffer data, String partitionKey, String sequenceNumberForOrdering) {
        return this.putRecordAsync(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey).withSequenceNumberForOrdering(sequenceNumberForOrdering));
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(String streamName, ByteBuffer data, String partitionKey, String sequenceNumberForOrdering, AsyncHandler<PutRecordRequest, PutRecordResult> asyncHandler) {
        return this.putRecordAsync(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey).withSequenceNumberForOrdering(sequenceNumberForOrdering), asyncHandler);
    }

    @Override
    public Future<PutRecordsResult> putRecordsAsync(PutRecordsRequest request) {
        return this.putRecordsAsync(request, null);
    }

    @Override
    public Future<PutRecordsResult> putRecordsAsync(final PutRecordsRequest request, final AsyncHandler<PutRecordsRequest, PutRecordsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutRecordsResult>(){

            @Override
            public PutRecordsResult call() throws Exception {
                PutRecordsResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.putRecords(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromStreamResult> removeTagsFromStreamAsync(RemoveTagsFromStreamRequest request) {
        return this.removeTagsFromStreamAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromStreamResult> removeTagsFromStreamAsync(final RemoveTagsFromStreamRequest request, final AsyncHandler<RemoveTagsFromStreamRequest, RemoveTagsFromStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsFromStreamResult>(){

            @Override
            public RemoveTagsFromStreamResult call() throws Exception {
                RemoveTagsFromStreamResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.removeTagsFromStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SplitShardResult> splitShardAsync(SplitShardRequest request) {
        return this.splitShardAsync(request, null);
    }

    @Override
    public Future<SplitShardResult> splitShardAsync(final SplitShardRequest request, final AsyncHandler<SplitShardRequest, SplitShardResult> asyncHandler) {
        return this.executorService.submit(new Callable<SplitShardResult>(){

            @Override
            public SplitShardResult call() throws Exception {
                SplitShardResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.splitShard(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SplitShardResult> splitShardAsync(String streamName, String shardToSplit, String newStartingHashKey) {
        return this.splitShardAsync(new SplitShardRequest().withStreamName(streamName).withShardToSplit(shardToSplit).withNewStartingHashKey(newStartingHashKey));
    }

    @Override
    public Future<SplitShardResult> splitShardAsync(String streamName, String shardToSplit, String newStartingHashKey, AsyncHandler<SplitShardRequest, SplitShardResult> asyncHandler) {
        return this.splitShardAsync(new SplitShardRequest().withStreamName(streamName).withShardToSplit(shardToSplit).withNewStartingHashKey(newStartingHashKey), asyncHandler);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

