/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.ListPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListPoliciesRequestMarshaller
implements Marshaller<Request<ListPoliciesRequest>, ListPoliciesRequest> {
    @Override
    public Request<ListPoliciesRequest> marshall(ListPoliciesRequest listPoliciesRequest) {
        if (listPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPoliciesRequest> request = new DefaultRequest<ListPoliciesRequest>(listPoliciesRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "ListPolicies");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listPoliciesRequest.getScope() != null) {
            request.addParameter("Scope", StringUtils.fromString(listPoliciesRequest.getScope()));
        }
        if (listPoliciesRequest.getOnlyAttached() != null) {
            request.addParameter("OnlyAttached", StringUtils.fromBoolean(listPoliciesRequest.getOnlyAttached()));
        }
        if (listPoliciesRequest.getPathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString(listPoliciesRequest.getPathPrefix()));
        }
        if (listPoliciesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listPoliciesRequest.getMarker()));
        }
        if (listPoliciesRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listPoliciesRequest.getMaxItems()));
        }
        return request;
    }
}

