/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidp.model.AuthFlowType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class InitiateAuthRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String authFlow;
    private Map<String, String> authParameters;
    private Map<String, String> clientMetadata;
    private String clientId;

    public void setAuthFlow(String authFlow) {
        this.authFlow = authFlow;
    }

    public String getAuthFlow() {
        return this.authFlow;
    }

    public InitiateAuthRequest withAuthFlow(String authFlow) {
        this.setAuthFlow(authFlow);
        return this;
    }

    public void setAuthFlow(AuthFlowType authFlow) {
        this.authFlow = authFlow.toString();
    }

    public InitiateAuthRequest withAuthFlow(AuthFlowType authFlow) {
        this.setAuthFlow(authFlow);
        return this;
    }

    public Map<String, String> getAuthParameters() {
        return this.authParameters;
    }

    public void setAuthParameters(Map<String, String> authParameters) {
        this.authParameters = authParameters;
    }

    public InitiateAuthRequest withAuthParameters(Map<String, String> authParameters) {
        this.setAuthParameters(authParameters);
        return this;
    }

    public InitiateAuthRequest addAuthParametersEntry(String key, String value) {
        if (null == this.authParameters) {
            this.authParameters = new HashMap<String, String>();
        }
        if (this.authParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.authParameters.put(key, value);
        return this;
    }

    public InitiateAuthRequest clearAuthParametersEntries() {
        this.authParameters = null;
        return this;
    }

    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    public InitiateAuthRequest withClientMetadata(Map<String, String> clientMetadata) {
        this.setClientMetadata(clientMetadata);
        return this;
    }

    public InitiateAuthRequest addClientMetadataEntry(String key, String value) {
        if (null == this.clientMetadata) {
            this.clientMetadata = new HashMap<String, String>();
        }
        if (this.clientMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.clientMetadata.put(key, value);
        return this;
    }

    public InitiateAuthRequest clearClientMetadataEntries() {
        this.clientMetadata = null;
        return this;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public InitiateAuthRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthFlow() != null) {
            sb.append("AuthFlow: ").append(this.getAuthFlow()).append(",");
        }
        if (this.getAuthParameters() != null) {
            sb.append("AuthParameters: ").append(this.getAuthParameters()).append(",");
        }
        if (this.getClientMetadata() != null) {
            sb.append("ClientMetadata: ").append(this.getClientMetadata()).append(",");
        }
        if (this.getClientId() != null) {
            sb.append("ClientId: ").append(this.getClientId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateAuthRequest)) {
            return false;
        }
        InitiateAuthRequest other = (InitiateAuthRequest)obj;
        if (other.getAuthFlow() == null ^ this.getAuthFlow() == null) {
            return false;
        }
        if (other.getAuthFlow() != null && !other.getAuthFlow().equals(this.getAuthFlow())) {
            return false;
        }
        if (other.getAuthParameters() == null ^ this.getAuthParameters() == null) {
            return false;
        }
        if (other.getAuthParameters() != null && !other.getAuthParameters().equals(this.getAuthParameters())) {
            return false;
        }
        if (other.getClientMetadata() == null ^ this.getClientMetadata() == null) {
            return false;
        }
        if (other.getClientMetadata() != null && !other.getClientMetadata().equals(this.getClientMetadata())) {
            return false;
        }
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        return other.getClientId() == null || other.getClientId().equals(this.getClientId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthFlow() == null ? 0 : this.getAuthFlow().hashCode());
        hashCode = 31 * hashCode + (this.getAuthParameters() == null ? 0 : this.getAuthParameters().hashCode());
        hashCode = 31 * hashCode + (this.getClientMetadata() == null ? 0 : this.getClientMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        return hashCode;
    }

    @Override
    public InitiateAuthRequest clone() {
        return (InitiateAuthRequest)super.clone();
    }
}

