/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.ChefConfiguration;

public class ChefConfigurationJsonMarshaller {
    private static ChefConfigurationJsonMarshaller instance;

    public void marshall(ChefConfiguration chefConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (chefConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (chefConfiguration.getManageBerkshelf() != null) {
                jsonGenerator.writeFieldName("ManageBerkshelf").writeValue(chefConfiguration.getManageBerkshelf());
            }
            if (chefConfiguration.getBerkshelfVersion() != null) {
                jsonGenerator.writeFieldName("BerkshelfVersion").writeValue(chefConfiguration.getBerkshelfVersion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ChefConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ChefConfigurationJsonMarshaller();
        }
        return instance;
    }
}

