/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class IpPermission
implements Serializable,
Cloneable {
    private String ipProtocol;
    private Integer fromPort;
    private Integer toPort;
    private SdkInternalList<UserIdGroupPair> userIdGroupPairs;
    private SdkInternalList<String> ipRanges;
    private SdkInternalList<PrefixListId> prefixListIds;

    public void setIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    public String getIpProtocol() {
        return this.ipProtocol;
    }

    public IpPermission withIpProtocol(String ipProtocol) {
        this.setIpProtocol(ipProtocol);
        return this;
    }

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public IpPermission withFromPort(Integer fromPort) {
        this.setFromPort(fromPort);
        return this;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public IpPermission withToPort(Integer toPort) {
        this.setToPort(toPort);
        return this;
    }

    public List<UserIdGroupPair> getUserIdGroupPairs() {
        if (this.userIdGroupPairs == null) {
            this.userIdGroupPairs = new SdkInternalList();
        }
        return this.userIdGroupPairs;
    }

    public void setUserIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
        if (userIdGroupPairs == null) {
            this.userIdGroupPairs = null;
            return;
        }
        this.userIdGroupPairs = new SdkInternalList<UserIdGroupPair>(userIdGroupPairs);
    }

    public IpPermission withUserIdGroupPairs(UserIdGroupPair ... userIdGroupPairs) {
        if (this.userIdGroupPairs == null) {
            this.setUserIdGroupPairs(new SdkInternalList<UserIdGroupPair>(userIdGroupPairs.length));
        }
        for (UserIdGroupPair ele : userIdGroupPairs) {
            this.userIdGroupPairs.add(ele);
        }
        return this;
    }

    public IpPermission withUserIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
        this.setUserIdGroupPairs(userIdGroupPairs);
        return this;
    }

    public List<String> getIpRanges() {
        if (this.ipRanges == null) {
            this.ipRanges = new SdkInternalList();
        }
        return this.ipRanges;
    }

    public void setIpRanges(Collection<String> ipRanges) {
        if (ipRanges == null) {
            this.ipRanges = null;
            return;
        }
        this.ipRanges = new SdkInternalList<String>(ipRanges);
    }

    public IpPermission withIpRanges(String ... ipRanges) {
        if (this.ipRanges == null) {
            this.setIpRanges(new SdkInternalList<String>(ipRanges.length));
        }
        for (String ele : ipRanges) {
            this.ipRanges.add(ele);
        }
        return this;
    }

    public IpPermission withIpRanges(Collection<String> ipRanges) {
        this.setIpRanges(ipRanges);
        return this;
    }

    public List<PrefixListId> getPrefixListIds() {
        if (this.prefixListIds == null) {
            this.prefixListIds = new SdkInternalList();
        }
        return this.prefixListIds;
    }

    public void setPrefixListIds(Collection<PrefixListId> prefixListIds) {
        if (prefixListIds == null) {
            this.prefixListIds = null;
            return;
        }
        this.prefixListIds = new SdkInternalList<PrefixListId>(prefixListIds);
    }

    public IpPermission withPrefixListIds(PrefixListId ... prefixListIds) {
        if (this.prefixListIds == null) {
            this.setPrefixListIds(new SdkInternalList<PrefixListId>(prefixListIds.length));
        }
        for (PrefixListId ele : prefixListIds) {
            this.prefixListIds.add(ele);
        }
        return this;
    }

    public IpPermission withPrefixListIds(Collection<PrefixListId> prefixListIds) {
        this.setPrefixListIds(prefixListIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpProtocol() != null) {
            sb.append("IpProtocol: " + this.getIpProtocol() + ",");
        }
        if (this.getFromPort() != null) {
            sb.append("FromPort: " + this.getFromPort() + ",");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: " + this.getToPort() + ",");
        }
        if (this.getUserIdGroupPairs() != null) {
            sb.append("UserIdGroupPairs: " + this.getUserIdGroupPairs() + ",");
        }
        if (this.getIpRanges() != null) {
            sb.append("IpRanges: " + this.getIpRanges() + ",");
        }
        if (this.getPrefixListIds() != null) {
            sb.append("PrefixListIds: " + this.getPrefixListIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission)obj;
        if (other.getIpProtocol() == null ^ this.getIpProtocol() == null) {
            return false;
        }
        if (other.getIpProtocol() != null && !other.getIpProtocol().equals(this.getIpProtocol())) {
            return false;
        }
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        if (other.getToPort() != null && !other.getToPort().equals(this.getToPort())) {
            return false;
        }
        if (other.getUserIdGroupPairs() == null ^ this.getUserIdGroupPairs() == null) {
            return false;
        }
        if (other.getUserIdGroupPairs() != null && !other.getUserIdGroupPairs().equals(this.getUserIdGroupPairs())) {
            return false;
        }
        if (other.getIpRanges() == null ^ this.getIpRanges() == null) {
            return false;
        }
        if (other.getIpRanges() != null && !other.getIpRanges().equals(this.getIpRanges())) {
            return false;
        }
        if (other.getPrefixListIds() == null ^ this.getPrefixListIds() == null) {
            return false;
        }
        return other.getPrefixListIds() == null || other.getPrefixListIds().equals(this.getPrefixListIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpProtocol() == null ? 0 : this.getIpProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        hashCode = 31 * hashCode + (this.getUserIdGroupPairs() == null ? 0 : this.getUserIdGroupPairs().hashCode());
        hashCode = 31 * hashCode + (this.getIpRanges() == null ? 0 : this.getIpRanges().hashCode());
        hashCode = 31 * hashCode + (this.getPrefixListIds() == null ? 0 : this.getPrefixListIds().hashCode());
        return hashCode;
    }

    public IpPermission clone() {
        try {
            return (IpPermission)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

