/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingsRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.ItemConverter;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class DynamoDBTableSchemaParser {
    private final Map<Class<?>, TableIndexesInfo> tableIndexesInfoCache = new HashMap();

    DynamoDBTableSchemaParser() {
    }

    CreateTableRequest parseTablePojoToCreateTableRequest(Class<?> clazz, DynamoDBMapperConfig config, DynamoDBMappingsRegistry registry, ItemConverter converter) {
        TableIndexesInfo indexesInfo;
        CreateTableRequest createTableRequest = new CreateTableRequest();
        createTableRequest.setTableName(DynamoDBMapper.internalGetTableName(clazz, null, config));
        DynamoDBMappingsRegistry.Mappings mappings = registry.mappingsOf(clazz);
        AttributeDefinition pHashAttrDefinition = DynamoDBTableSchemaParser.getKeyAttributeDefinition(mappings.getHashKey(), converter);
        createTableRequest.withKeySchema(new KeySchemaElement(pHashAttrDefinition.getAttributeName(), KeyType.HASH));
        AttributeDefinition pRangeAttrDefinition = null;
        if (mappings.hasRangeKey()) {
            pRangeAttrDefinition = DynamoDBTableSchemaParser.getKeyAttributeDefinition(mappings.getRangeKey(), converter);
            createTableRequest.withKeySchema(new KeySchemaElement(pRangeAttrDefinition.getAttributeName(), KeyType.RANGE));
        }
        if (!(indexesInfo = this.parseTableIndexes(clazz, registry)).getGlobalSecondaryIndexes().isEmpty()) {
            createTableRequest.setGlobalSecondaryIndexes(indexesInfo.getGlobalSecondaryIndexes());
        }
        if (!indexesInfo.getLocalSecondaryIndexes().isEmpty()) {
            createTableRequest.setLocalSecondaryIndexes(indexesInfo.getLocalSecondaryIndexes());
        }
        HashMap<String, AttributeDefinition> attrDefinitions = new HashMap<String, AttributeDefinition>();
        DynamoDBTableSchemaParser.putAfterCheckConflict(attrDefinitions, pHashAttrDefinition);
        if (mappings.hasRangeKey()) {
            DynamoDBTableSchemaParser.putAfterCheckConflict(attrDefinitions, pRangeAttrDefinition);
        }
        for (DynamoDBMappingsRegistry.Mapping indexKeyMapping : indexesInfo.getIndexKeyMappings()) {
            AttributeDefinition indexKeyAttrDefinition = DynamoDBTableSchemaParser.getKeyAttributeDefinition(indexKeyMapping, converter);
            DynamoDBTableSchemaParser.putAfterCheckConflict(attrDefinitions, indexKeyAttrDefinition);
        }
        createTableRequest.setAttributeDefinitions(attrDefinitions.values());
        return createTableRequest;
    }

    DeleteTableRequest parseTablePojoToDeleteTableRequest(Class<?> clazz, DynamoDBMapperConfig config) {
        DeleteTableRequest deleteTableRequest = new DeleteTableRequest();
        deleteTableRequest.setTableName(DynamoDBMapper.internalGetTableName(clazz, null, config));
        return deleteTableRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableIndexesInfo parseTableIndexes(Class<?> clazz, DynamoDBMappingsRegistry registry) {
        Map<Class<?>, TableIndexesInfo> map = this.tableIndexesInfoCache;
        synchronized (map) {
            if (!this.tableIndexesInfoCache.containsKey(clazz)) {
                DynamoDBMappingsRegistry.Mappings mappings = registry.mappingsOf(clazz);
                TableIndexesInfo tableIndexInfo = new TableIndexesInfo();
                String pHashName = mappings.getHashKey().getAttributeName();
                for (DynamoDBMappingsRegistry.Mapping mapping : mappings.getMappings()) {
                    for (String gsi : mapping.bean().annotations().globalSecondaryIndexNames(KeyType.HASH)) {
                        tableIndexInfo.addGsiKeys(gsi, mapping.getAttributeName(), null);
                        tableIndexInfo.addIndexKeyMapping(mapping);
                    }
                    for (String gsi : mapping.bean().annotations().globalSecondaryIndexNames(KeyType.RANGE)) {
                        tableIndexInfo.addGsiKeys(gsi, null, mapping.getAttributeName());
                        tableIndexInfo.addIndexKeyMapping(mapping);
                    }
                    for (String lsi : mapping.bean().annotations().localSecondaryIndexNames()) {
                        tableIndexInfo.addLsiRangeKey(lsi, pHashName, mapping.getAttributeName());
                        tableIndexInfo.addIndexKeyMapping(mapping);
                    }
                }
                this.tableIndexesInfoCache.put(clazz, tableIndexInfo);
            }
            return this.tableIndexesInfoCache.get(clazz);
        }
    }

    private static AttributeDefinition getKeyAttributeDefinition(DynamoDBMappingsRegistry.Mapping keyMapping, ItemConverter converter) {
        DynamoDBMapperFieldModel fieldModel = converter.getFieldModel(keyMapping.getter());
        DynamoDBMapperFieldModel.DynamoDBAttributeType keyType = fieldModel.getDynamoDBAttributeType();
        if (keyType == DynamoDBMapperFieldModel.DynamoDBAttributeType.S || keyType == DynamoDBMapperFieldModel.DynamoDBAttributeType.N || keyType == DynamoDBMapperFieldModel.DynamoDBAttributeType.B) {
            return new AttributeDefinition(keyMapping.getAttributeName(), keyType.toString());
        }
        throw new DynamoDBMappingException("The key attribute must be in a scalar type (String, Number or Binary).");
    }

    private static void putAfterCheckConflict(Map<String, AttributeDefinition> map, AttributeDefinition attrDefinition) {
        String attrName = attrDefinition.getAttributeName();
        AttributeDefinition existingDefinition = map.get(attrName);
        if (existingDefinition != null && !existingDefinition.equals(attrDefinition)) {
            throw new DynamoDBMappingException("Found conflicting definitions for attribute [" + attrName + "]: " + existingDefinition + " and " + attrDefinition + ".");
        }
        map.put(attrName, attrDefinition);
    }

    static class TableIndexesInfo {
        private final Map<String, Set<String>> lsiRangeKeyNameToIndexNames = new HashMap<String, Set<String>>();
        private final Map<String, Set<String>> gsiHashKeyNameToIndexNames = new HashMap<String, Set<String>>();
        private final Map<String, Set<String>> gsiRangeKeyNameToIndexNames = new HashMap<String, Set<String>>();
        private final Map<String, LocalSecondaryIndex> lsiNameToLsiDefinition = new HashMap<String, LocalSecondaryIndex>();
        private final Map<String, GlobalSecondaryIndex> gsiNameToGsiDefinition = new HashMap<String, GlobalSecondaryIndex>();
        private final Set<DynamoDBMappingsRegistry.Mapping> indexKeyMappings = new HashSet<DynamoDBMappingsRegistry.Mapping>();

        TableIndexesInfo() {
        }

        public Set<String> getLsiNamesByIndexRangeKey(String indexRangeKeyName) {
            Set<String> lsiNames = this.lsiRangeKeyNameToIndexNames.get(indexRangeKeyName);
            if (lsiNames != null) {
                lsiNames = Collections.unmodifiableSet(lsiNames);
            }
            return lsiNames;
        }

        public Set<String> getGsiNamesByIndexHashKey(String indexHashKeyName) {
            Set<String> gsiNames = this.gsiHashKeyNameToIndexNames.get(indexHashKeyName);
            if (gsiNames != null) {
                gsiNames = Collections.unmodifiableSet(gsiNames);
            }
            return gsiNames;
        }

        public Set<String> getGsiNamesByIndexRangeKey(String indexRangeKeyName) {
            Set<String> gsiNames = this.gsiRangeKeyNameToIndexNames.get(indexRangeKeyName);
            if (gsiNames != null) {
                gsiNames = Collections.unmodifiableSet(gsiNames);
            }
            return gsiNames;
        }

        public Set<String> getAllLsiNames() {
            return Collections.unmodifiableSet(this.lsiNameToLsiDefinition.keySet());
        }

        public Set<String> getAllGsiNames() {
            return Collections.unmodifiableSet(this.gsiNameToGsiDefinition.keySet());
        }

        private void addGsiKeys(String gsiName, String gsiHashKeyName, String gsiRangeKeyName) {
            GlobalSecondaryIndex gsi;
            if (this.gsiNameToGsiDefinition.containsKey(gsiName)) {
                GlobalSecondaryIndex existingGsi;
                gsi = existingGsi = this.gsiNameToGsiDefinition.get(gsiName);
                if (!gsiName.equals(existingGsi.getIndexName())) {
                    throw new IllegalStateException("Found invalid state of an existing GlobalSecondaryIndex object associated with the GSI [" + gsiName + "].");
                }
                for (KeySchemaElement existingKey : existingGsi.getKeySchema()) {
                    String existingKeyName = existingKey.getAttributeName();
                    String existingKeyType = existingKey.getKeyType();
                    if (KeyType.HASH.toString().equals(existingKeyType)) {
                        if (gsiHashKeyName == null || gsiHashKeyName.equals(existingKeyName)) continue;
                        throw new DynamoDBMappingException("Multiple hash keys [" + existingKeyName + ", " + gsiHashKeyName + "] are found for the GSI [" + gsiName + "]. Each index allows at most one range key attribute.");
                    }
                    if (KeyType.RANGE.toString().equals(existingKeyType)) {
                        if (gsiRangeKeyName == null || gsiRangeKeyName.equals(existingKeyName)) continue;
                        throw new DynamoDBMappingException("Multiple range keys [" + existingKeyName + ", " + gsiRangeKeyName + "] are found for the GSI [" + gsiName + "]. Each index allows at most one range key attribute.");
                    }
                    throw new IllegalStateException("Found invalid state of an existing GlobalSecondaryIndex object associated with the GSI [" + gsiName + "].");
                }
            } else {
                gsi = new GlobalSecondaryIndex().withIndexName(gsiName).withProjection(new Projection().withProjectionType(ProjectionType.KEYS_ONLY));
                this.gsiNameToGsiDefinition.put(gsiName, gsi);
            }
            if (gsiHashKeyName != null) {
                if (gsi.getKeySchema() == null || gsi.getKeySchema().isEmpty()) {
                    gsi.withKeySchema(new KeySchemaElement(gsiHashKeyName, KeyType.HASH));
                } else {
                    LinkedList<KeySchemaElement> orderedKeys = new LinkedList<KeySchemaElement>(gsi.getKeySchema());
                    orderedKeys.addFirst(new KeySchemaElement(gsiHashKeyName, KeyType.HASH));
                    gsi.setKeySchema(orderedKeys);
                }
                this.mapGsiHashKeyToIndexName(gsiHashKeyName, gsiName);
            }
            if (gsiRangeKeyName != null) {
                gsi.withKeySchema(new KeySchemaElement(gsiRangeKeyName, KeyType.RANGE));
                this.mapGsiRangeKeyToIndexName(gsiRangeKeyName, gsiName);
            }
        }

        private void addLsiRangeKey(String lsiName, String pHashKeyName, String lsiRangeKeyName) {
            if (pHashKeyName == null) {
                throw new IllegalArgumentException("The name of the primary hash key must be specified.");
            }
            if (this.lsiNameToLsiDefinition.containsKey(lsiName)) {
                LocalSecondaryIndex existingLsi = this.lsiNameToLsiDefinition.get(lsiName);
                if (!lsiName.equals(existingLsi.getIndexName()) || existingLsi.getKeySchema() == null || existingLsi.getKeySchema().size() != 2 || !KeyType.RANGE.toString().equals(existingLsi.getKeySchema().get(1).getKeyType())) {
                    throw new IllegalStateException("Found invalid state of an existing LocalSecondaryIndex object associated with the LSI [" + lsiName + "].");
                }
                String existingLsiRangeKeyName = existingLsi.getKeySchema().get(1).getAttributeName();
                if (!existingLsiRangeKeyName.equals(lsiRangeKeyName)) {
                    throw new DynamoDBMappingException("Multiple range keys [" + existingLsiRangeKeyName + ", " + lsiRangeKeyName + "] are found for the LSI [" + lsiName + "]. Each index allows at most one range key attribute.");
                }
            } else {
                this.lsiNameToLsiDefinition.put(lsiName, new LocalSecondaryIndex().withIndexName(lsiName).withKeySchema(new KeySchemaElement(pHashKeyName, KeyType.HASH), new KeySchemaElement(lsiRangeKeyName, KeyType.RANGE)).withProjection(new Projection().withProjectionType(ProjectionType.KEYS_ONLY)));
                this.mapLsiRangeKeyToIndexName(lsiRangeKeyName, lsiName);
            }
        }

        private void mapLsiRangeKeyToIndexName(String lsiRangeKeyName, String lsiName) {
            this.mapIndexKeyToIndexName(this.lsiRangeKeyNameToIndexNames, lsiRangeKeyName, lsiName);
        }

        private void mapGsiHashKeyToIndexName(String gsiHashKeyName, String gsiName) {
            this.mapIndexKeyToIndexName(this.gsiHashKeyNameToIndexNames, gsiHashKeyName, gsiName);
        }

        private void mapGsiRangeKeyToIndexName(String gsiRangeKeyName, String gsiName) {
            this.mapIndexKeyToIndexName(this.gsiRangeKeyNameToIndexNames, gsiRangeKeyName, gsiName);
        }

        private void mapIndexKeyToIndexName(Map<String, Set<String>> indexKeyNameToIndexNames, String indexKeyName, String indexName) {
            if (indexKeyNameToIndexNames.get(indexKeyName) == null) {
                HashSet<String> indexNames = new HashSet<String>();
                indexNames.add(indexName);
                indexKeyNameToIndexNames.put(indexKeyName, indexNames);
            } else {
                indexKeyNameToIndexNames.get(indexKeyName).add(indexName);
            }
        }

        private void addIndexKeyMapping(DynamoDBMappingsRegistry.Mapping indexKeyMapping) {
            this.indexKeyMappings.add(indexKeyMapping);
        }

        private Set<DynamoDBMappingsRegistry.Mapping> getIndexKeyMappings() {
            return Collections.unmodifiableSet(this.indexKeyMappings);
        }

        private Collection<LocalSecondaryIndex> getLocalSecondaryIndexes() {
            return Collections.unmodifiableCollection(this.lsiNameToLsiDefinition.values());
        }

        private Collection<GlobalSecondaryIndex> getGlobalSecondaryIndexes() {
            return Collections.unmodifiableCollection(this.gsiNameToGsiDefinition.values());
        }
    }
}

