/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.ParameterObject;
import com.amazonaws.services.datapipeline.model.ParameterValue;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.transform.ParameterObjectJsonMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ParameterValueJsonMarshaller;
import com.amazonaws.services.datapipeline.model.transform.PipelineObjectJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ValidatePipelineDefinitionRequestMarshaller
implements Marshaller<Request<ValidatePipelineDefinitionRequest>, ValidatePipelineDefinitionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ValidatePipelineDefinitionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ValidatePipelineDefinitionRequest> marshall(ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) {
        if (validatePipelineDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ValidatePipelineDefinitionRequest> request = new DefaultRequest<ValidatePipelineDefinitionRequest>(validatePipelineDefinitionRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.ValidatePipelineDefinition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList parameterValuesList;
            SdkInternalList parameterObjectsList;
            SdkInternalList pipelineObjectsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (validatePipelineDefinitionRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(validatePipelineDefinitionRequest.getPipelineId());
            }
            if (!(pipelineObjectsList = (SdkInternalList)validatePipelineDefinitionRequest.getPipelineObjects()).isEmpty() || !pipelineObjectsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("pipelineObjects");
                jsonGenerator.writeStartArray();
                for (Object pipelineObjectsListValue : pipelineObjectsList) {
                    if (pipelineObjectsListValue == null) continue;
                    PipelineObjectJsonMarshaller.getInstance().marshall((PipelineObject)pipelineObjectsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(parameterObjectsList = (SdkInternalList)validatePipelineDefinitionRequest.getParameterObjects()).isEmpty() || !parameterObjectsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("parameterObjects");
                jsonGenerator.writeStartArray();
                for (Object parameterObjectsListValue : parameterObjectsList) {
                    if (parameterObjectsListValue == null) continue;
                    ParameterObjectJsonMarshaller.getInstance().marshall((ParameterObject)parameterObjectsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(parameterValuesList = (SdkInternalList)validatePipelineDefinitionRequest.getParameterValues()).isEmpty() || !parameterValuesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("parameterValues");
                jsonGenerator.writeStartArray();
                for (ParameterValue parameterValuesListValue : parameterValuesList) {
                    if (parameterValuesListValue == null) continue;
                    ParameterValueJsonMarshaller.getInstance().marshall(parameterValuesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

