/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.IpRoute;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AddIpRoutesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryId;
    private SdkInternalList<IpRoute> ipRoutes;
    private Boolean updateSecurityGroupForDirectoryControllers;

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public AddIpRoutesRequest withDirectoryId(String directoryId) {
        this.setDirectoryId(directoryId);
        return this;
    }

    public List<IpRoute> getIpRoutes() {
        if (this.ipRoutes == null) {
            this.ipRoutes = new SdkInternalList();
        }
        return this.ipRoutes;
    }

    public void setIpRoutes(Collection<IpRoute> ipRoutes) {
        if (ipRoutes == null) {
            this.ipRoutes = null;
            return;
        }
        this.ipRoutes = new SdkInternalList<IpRoute>(ipRoutes);
    }

    public AddIpRoutesRequest withIpRoutes(IpRoute ... ipRoutes) {
        if (this.ipRoutes == null) {
            this.setIpRoutes(new SdkInternalList<IpRoute>(ipRoutes.length));
        }
        for (IpRoute ele : ipRoutes) {
            this.ipRoutes.add(ele);
        }
        return this;
    }

    public AddIpRoutesRequest withIpRoutes(Collection<IpRoute> ipRoutes) {
        this.setIpRoutes(ipRoutes);
        return this;
    }

    public void setUpdateSecurityGroupForDirectoryControllers(Boolean updateSecurityGroupForDirectoryControllers) {
        this.updateSecurityGroupForDirectoryControllers = updateSecurityGroupForDirectoryControllers;
    }

    public Boolean getUpdateSecurityGroupForDirectoryControllers() {
        return this.updateSecurityGroupForDirectoryControllers;
    }

    public AddIpRoutesRequest withUpdateSecurityGroupForDirectoryControllers(Boolean updateSecurityGroupForDirectoryControllers) {
        this.setUpdateSecurityGroupForDirectoryControllers(updateSecurityGroupForDirectoryControllers);
        return this;
    }

    public Boolean isUpdateSecurityGroupForDirectoryControllers() {
        return this.updateSecurityGroupForDirectoryControllers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: ").append(this.getDirectoryId()).append(",");
        }
        if (this.getIpRoutes() != null) {
            sb.append("IpRoutes: ").append(this.getIpRoutes()).append(",");
        }
        if (this.getUpdateSecurityGroupForDirectoryControllers() != null) {
            sb.append("UpdateSecurityGroupForDirectoryControllers: ").append(this.getUpdateSecurityGroupForDirectoryControllers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddIpRoutesRequest)) {
            return false;
        }
        AddIpRoutesRequest other = (AddIpRoutesRequest)obj;
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getIpRoutes() == null ^ this.getIpRoutes() == null) {
            return false;
        }
        if (other.getIpRoutes() != null && !other.getIpRoutes().equals(this.getIpRoutes())) {
            return false;
        }
        if (other.getUpdateSecurityGroupForDirectoryControllers() == null ^ this.getUpdateSecurityGroupForDirectoryControllers() == null) {
            return false;
        }
        return other.getUpdateSecurityGroupForDirectoryControllers() == null || other.getUpdateSecurityGroupForDirectoryControllers().equals(this.getUpdateSecurityGroupForDirectoryControllers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getIpRoutes() == null ? 0 : this.getIpRoutes().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateSecurityGroupForDirectoryControllers() == null ? 0 : this.getUpdateSecurityGroupForDirectoryControllers().hashCode());
        return hashCode;
    }

    @Override
    public AddIpRoutesRequest clone() {
        return (AddIpRoutesRequest)super.clone();
    }
}

