/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.KinesisAction;

@SdkInternalApi
public class KinesisActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamName").build();
    private static final MarshallingInfo<String> PARTITIONKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partitionKey").build();
    private static final KinesisActionMarshaller instance = new KinesisActionMarshaller();

    public static KinesisActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(KinesisAction kinesisAction, ProtocolMarshaller protocolMarshaller) {
        if (kinesisAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(kinesisAction.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(kinesisAction.getStreamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall(kinesisAction.getPartitionKey(), PARTITIONKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

