/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SetSubnetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String loadBalancerArn;
    private List<String> subnets;

    public void setLoadBalancerArn(String loadBalancerArn) {
        this.loadBalancerArn = loadBalancerArn;
    }

    public String getLoadBalancerArn() {
        return this.loadBalancerArn;
    }

    public SetSubnetsRequest withLoadBalancerArn(String loadBalancerArn) {
        this.setLoadBalancerArn(loadBalancerArn);
        return this;
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new ArrayList<String>(subnets);
    }

    public SetSubnetsRequest withSubnets(String ... subnets) {
        if (this.subnets == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    public SetSubnetsRequest withSubnets(Collection<String> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.getLoadBalancerArn()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubnetsRequest)) {
            return false;
        }
        SetSubnetsRequest other = (SetSubnetsRequest)obj;
        if (other.getLoadBalancerArn() == null ^ this.getLoadBalancerArn() == null) {
            return false;
        }
        if (other.getLoadBalancerArn() != null && !other.getLoadBalancerArn().equals(this.getLoadBalancerArn())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        return other.getSubnets() == null || other.getSubnets().equals(this.getSubnets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerArn() == null ? 0 : this.getLoadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        return hashCode;
    }

    @Override
    public SetSubnetsRequest clone() {
        return (SetSubnetsRequest)super.clone();
    }
}

