/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.ResourceTag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListTagsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<ResourceTag> resourceTagList;
    private String nextToken;

    public List<ResourceTag> getResourceTagList() {
        if (this.resourceTagList == null) {
            this.resourceTagList = new SdkInternalList();
        }
        return this.resourceTagList;
    }

    public void setResourceTagList(Collection<ResourceTag> resourceTagList) {
        if (resourceTagList == null) {
            this.resourceTagList = null;
            return;
        }
        this.resourceTagList = new SdkInternalList<ResourceTag>(resourceTagList);
    }

    public ListTagsResult withResourceTagList(ResourceTag ... resourceTagList) {
        if (this.resourceTagList == null) {
            this.setResourceTagList(new SdkInternalList<ResourceTag>(resourceTagList.length));
        }
        for (ResourceTag ele : resourceTagList) {
            this.resourceTagList.add(ele);
        }
        return this;
    }

    public ListTagsResult withResourceTagList(Collection<ResourceTag> resourceTagList) {
        this.setResourceTagList(resourceTagList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTagsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceTagList() != null) {
            sb.append("ResourceTagList: ").append(this.getResourceTagList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsResult)) {
            return false;
        }
        ListTagsResult other = (ListTagsResult)obj;
        if (other.getResourceTagList() == null ^ this.getResourceTagList() == null) {
            return false;
        }
        if (other.getResourceTagList() != null && !other.getResourceTagList().equals(this.getResourceTagList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceTagList() == null ? 0 : this.getResourceTagList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTagsResult clone() {
        try {
            return (ListTagsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

