/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.ActionState;
import com.amazonaws.services.codepipeline.model.StageState;
import com.amazonaws.services.codepipeline.model.transform.ActionStateJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.StageExecutionJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.TransitionStateJsonMarshaller;
import java.util.List;

public class StageStateJsonMarshaller {
    private static StageStateJsonMarshaller instance;

    public void marshall(StageState stageState, StructuredJsonGenerator jsonGenerator) {
        if (stageState == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ActionState> actionStatesList;
            jsonGenerator.writeStartObject();
            if (stageState.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(stageState.getStageName());
            }
            if (stageState.getInboundTransitionState() != null) {
                jsonGenerator.writeFieldName("inboundTransitionState");
                TransitionStateJsonMarshaller.getInstance().marshall(stageState.getInboundTransitionState(), jsonGenerator);
            }
            if ((actionStatesList = stageState.getActionStates()) != null) {
                jsonGenerator.writeFieldName("actionStates");
                jsonGenerator.writeStartArray();
                for (ActionState actionStatesListValue : actionStatesList) {
                    if (actionStatesListValue == null) continue;
                    ActionStateJsonMarshaller.getInstance().marshall(actionStatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (stageState.getLatestExecution() != null) {
                jsonGenerator.writeFieldName("latestExecution");
                StageExecutionJsonMarshaller.getInstance().marshall(stageState.getLatestExecution(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StageStateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StageStateJsonMarshaller();
        }
        return instance;
    }
}

