/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SolutionStackDescription
implements Serializable,
Cloneable {
    private String solutionStackName;
    private SdkInternalList<String> permittedFileTypes;

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public SolutionStackDescription withSolutionStackName(String solutionStackName) {
        this.setSolutionStackName(solutionStackName);
        return this;
    }

    public List<String> getPermittedFileTypes() {
        if (this.permittedFileTypes == null) {
            this.permittedFileTypes = new SdkInternalList();
        }
        return this.permittedFileTypes;
    }

    public void setPermittedFileTypes(Collection<String> permittedFileTypes) {
        if (permittedFileTypes == null) {
            this.permittedFileTypes = null;
            return;
        }
        this.permittedFileTypes = new SdkInternalList<String>(permittedFileTypes);
    }

    public SolutionStackDescription withPermittedFileTypes(String ... permittedFileTypes) {
        if (this.permittedFileTypes == null) {
            this.setPermittedFileTypes(new SdkInternalList<String>(permittedFileTypes.length));
        }
        for (String ele : permittedFileTypes) {
            this.permittedFileTypes.add(ele);
        }
        return this;
    }

    public SolutionStackDescription withPermittedFileTypes(Collection<String> permittedFileTypes) {
        this.setPermittedFileTypes(permittedFileTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.getSolutionStackName()).append(",");
        }
        if (this.getPermittedFileTypes() != null) {
            sb.append("PermittedFileTypes: ").append(this.getPermittedFileTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionStackDescription)) {
            return false;
        }
        SolutionStackDescription other = (SolutionStackDescription)obj;
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getPermittedFileTypes() == null ^ this.getPermittedFileTypes() == null) {
            return false;
        }
        return other.getPermittedFileTypes() == null || other.getPermittedFileTypes().equals(this.getPermittedFileTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getPermittedFileTypes() == null ? 0 : this.getPermittedFileTypes().hashCode());
        return hashCode;
    }

    public SolutionStackDescription clone() {
        try {
            return (SolutionStackDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

