/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.services.identitymanagement.model.ResourceSpecificResult;
import com.amazonaws.services.identitymanagement.model.Statement;
import com.amazonaws.services.identitymanagement.model.transform.StatementStaxUnmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class ResourceSpecificResultStaxUnmarshaller
implements Unmarshaller<ResourceSpecificResult, StaxUnmarshallerContext> {
    private static ResourceSpecificResultStaxUnmarshaller instance;

    @Override
    public ResourceSpecificResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceSpecificResult resourceSpecificResult = new ResourceSpecificResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceSpecificResult;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("EvalResourceName", targetDepth)) {
                    resourceSpecificResult.setEvalResourceName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EvalResourceDecision", targetDepth)) {
                    resourceSpecificResult.setEvalResourceDecision(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MatchedStatements", targetDepth)) {
                    resourceSpecificResult.withMatchedStatements(new ArrayList<Statement>());
                    continue;
                }
                if (context.testExpression("MatchedStatements/member", targetDepth)) {
                    resourceSpecificResult.withMatchedStatements(StatementStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MissingContextValues", targetDepth)) {
                    resourceSpecificResult.withMissingContextValues(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("MissingContextValues/member", targetDepth)) {
                    resourceSpecificResult.withMissingContextValues(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EvalDecisionDetails/entry", targetDepth)) continue;
                Map.Entry<String, String> entry = EvalDecisionDetailsMapEntryUnmarshaller.getInstance().unmarshall(context);
                resourceSpecificResult.addEvalDecisionDetailsEntry(entry.getKey(), entry.getValue());
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceSpecificResult;
    }

    public static ResourceSpecificResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceSpecificResultStaxUnmarshaller();
        }
        return instance;
    }

    private static class EvalDecisionDetailsMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static EvalDecisionDetailsMapEntryUnmarshaller instance;

        private EvalDecisionDetailsMapEntryUnmarshaller() {
        }

        @Override
        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry<String, String> entry = new MapEntry<String, String>();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static EvalDecisionDetailsMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new EvalDecisionDetailsMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

